/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb;

import java.io.InputStream;

public class RealInputStream
extends InputStream {
    private long c_state_;
    private long c_errhp_;
    private long m_gp_;
    private int m_type_;
    private int m_stream_offset = 0;
    public static final int OCISTREAM = 1;
    public static final int KGHSSTREAM = 2;

    private native int readNative(long var1, long var3, byte[] var5, int var6, int var7, int var8, long var9, int var11);

    private native void closeNative(long var1, long var3, int var5, long var6);

    public RealInputStream(long c_errhp, long c_state) {
        this.c_errhp_ = c_errhp;
        this.c_state_ = c_state;
        this.m_type_ = 1;
        this.m_gp_ = 0L;
    }

    public RealInputStream(long c_errhp, long c_state, int m_type, long m_gp) {
        this.c_errhp_ = c_errhp;
        this.c_state_ = c_state;
        this.m_type_ = m_type;
        this.m_gp_ = m_gp;
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public int read() {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) != -1) {
            return b[0];
        }
        return -1;
    }

    public boolean markSupported() {
        return false;
    }

    public int read(byte[] b, int off, int len) {
        if (off < 0 || len < 0 || b.length < len) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int nread = this.readNative(this.c_errhp_, this.c_state_, b, off, len, this.m_type_, this.m_gp_, this.m_stream_offset);
        this.m_stream_offset += nread;
        return nread;
    }

    public void close() {
        this.closeNative(this.c_errhp_, this.c_state_, this.m_type_, this.m_gp_);
    }
}

