/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.comp;

import java.io.IOException;
import java.util.Stack;
import javax.xml.namespace.QName;
import oracle.xml.comp.CXMLCodeSpace;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLReader;
import oracle.xml.comp.CXMLStream;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.TypedAttributes;
import oracle.xml.scalable.StreamWriter;
import oracle.xml.util.QxName;

public class CXMLWriter
extends StreamWriter
implements CXMLConstants {
    Stack skipOffsets;
    Stack tokenDefs;
    Boolean tkDefs;
    DTD dtd;
    byte[] buf;
    char[] chdata;
    int eventType;
    int flags;
    int chdataLen;
    int pageid;
    int readPos;
    int writePos;
    QxName qname;
    SAXAttrList attrs;
    CXMLReader.TypeInfo typeinfo;
    CXMLReader.TypeInfo attrtypeinfo;
    CXMLStream stream;

    CXMLWriter(CXMLStream cXMLStream) {
        this.stream = cXMLStream;
        this.attrs = new SAXAttrList(4);
        this.chdata = new char[256];
        this.typeinfo = new CXMLReader.TypeInfo();
        this.attrtypeinfo = new CXMLReader.TypeInfo();
        this.pageid = 0;
        this.writePos = 0;
        this.buf = this.stream.getWriteBuffer();
        this.skipOffsets = new Stack();
        this.tokenDefs = new Stack();
        this.tkDefs = Boolean.FALSE;
        this.dtd = null;
    }

    public void init() {
        this.buf = this.stream.getWriteBuffer();
        this.writePos = 0;
    }

    public void setVersion(String string) {
        this.stream.setVersion(string);
    }

    public void setEncoding(String string) {
        this.stream.setEncoding(string);
    }

    public void setStandalone(String string) {
        this.stream.setStandalone(string);
    }

    public void setDoctype(DTD dTD) {
        this.dtd = dTD;
    }

    public void setQName(QName qName) {
        this.qname = (QxName)qName;
    }

    public void setTypeName(QName qName) {
        this.typeinfo.typename = (QxName)qName;
    }

    public void setPrimitiveTypeId(int n) {
        this.typeinfo.typeid = n;
    }

    public void setGlobal(boolean bl) {
        this.typeinfo.global = bl;
    }

    public void setNilled(boolean bl) {
        this.typeinfo.nillable = bl;
    }

    public void setAttributes(TypedAttributes typedAttributes) {
        this.attrs = (SAXAttrList)typedAttributes;
    }

    public void setAttribute(QName qName, String string) {
        this.qname = (QxName)qName;
        this.setValue(string);
    }

    public void setValue(String string) {
        if (string == null) {
            string = "";
        }
        this.chdataLen = string.length();
        if (this.chdataLen > this.chdata.length) {
            this.chdata = new char[this.chdataLen];
        }
        string.getChars(0, this.chdataLen, this.chdata, 0);
    }

    public void setData(char[] cArray, int n, int n2) {
        if (n2 > this.chdata.length) {
            this.chdata = new char[n2];
        }
        this.chdataLen = n2;
        System.arraycopy(cArray, n, this.chdata, 0, n2);
    }

    public void setEventFlags(int n) {
        this.flags = n;
    }

    public void createEvent(int n) {
        this.eventType = n;
        this.clear();
    }

    public void save() {
        try {
            switch (this.eventType) {
                case 1: {
                    this.writeElemQName(this.qname);
                    this.writeTypeInfo(this.typeinfo);
                    this.writeAttributes();
                    this.startElementContent();
                    break;
                }
                case 2: {
                    this.endElementContent();
                    this.writeByte(22);
                    break;
                }
                case 3: {
                    this.writeByte(20);
                    this.writeUTF(this.qname.getQName());
                    this.writeUTF(this.chdata, 0, this.chdataLen);
                    this.writeBoolean((this.flags & 0x80) == 128);
                    break;
                }
                case 4: 
                case 6: {
                    this.writeByte(23);
                    this.writeUTF(this.chdata, 0, this.chdataLen);
                    break;
                }
                case 7: {
                    this.writeDocument();
                    break;
                }
                case 10: {
                    this.writeAttrQName(this.qname);
                    this.writeTypeInfo(this.typeinfo);
                    this.writeUTF(this.chdata, 0, this.chdataLen);
                    boolean bl = (this.flags & 0x10000) == 65536;
                    this.writeBoolean(bl);
                    break;
                }
                case 12: {
                    this.writeByte(21);
                    this.writeUTF(this.chdata, 0, this.chdataLen);
                    break;
                }
                case 5: {
                    this.writeByte(29);
                    this.writeUTF(this.chdata, 0, this.chdataLen);
                    this.writeBoolean((this.flags & 0x80) == 128);
                    break;
                }
                case 9: 
                case 14: {
                    this.writeByte(30);
                    this.writeUTF(this.qname.getQName());
                    break;
                }
                case 15: {
                    this.writeByte(22);
                    break;
                }
                case 8: {
                    this.writeByte(37);
                    break;
                }
                case 11: {
                    if (this.dtd != null) {
                        this.dtd.writeNodeInfo(this, true, false);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        catch (IOException iOException) {
            RuntimeException runtimeException = new RuntimeException(iOException.getMessage());
            runtimeException.initCause(iOException);
            throw runtimeException;
        }
    }

    private void writeAttributes() throws IOException {
        int n = this.attrs.getLength();
        for (int i = 0; i < n; ++i) {
            this.writeQName(this.attrs.getQName(i), this.attrs.getURI(i), false);
            this.attrtypeinfo.typename = (QxName)this.attrs.getTypeName(i);
            this.attrtypeinfo.typeid = this.attrs.getPrimitiveTypeId(i);
            this.writeTypeInfo(this.attrtypeinfo);
            this.writeUTF(this.attrs.getValue(i));
            this.writeBoolean(this.attrs.isSpecified(i));
        }
    }

    void startElementContent() throws IOException {
        CXMLReader.Offset offset = new CXMLReader.Offset(this.pageid, (short)this.writePos);
        this.skipOffsets.push(offset);
        this.tokenDefs.push(this.tkDefs);
        this.tkDefs = Boolean.FALSE;
        this.writeByte(34);
        this.writeShort(0);
    }

    void endElementContent() throws IOException {
        if (!this.skipOffsets.isEmpty()) {
            boolean bl;
            CXMLReader.Offset offset = (CXMLReader.Offset)this.skipOffsets.pop();
            int n = this.writePos - offset.pageoffset - 3;
            if (n >= 65535) {
                n = 0;
            }
            if (!(bl = ((Boolean)this.tokenDefs.pop()).booleanValue())) {
                this.buf[offset.pageoffset + 1] = (byte)(n >>> 8 & 0xFF);
                this.buf[offset.pageoffset + 2] = (byte)(n >>> 0 & 0xFF);
            } else if (!this.tokenDefs.isEmpty()) {
                this.tokenDefs.pop();
                this.tokenDefs.push(Boolean.TRUE);
            }
        }
    }

    public void writeByte(int n) throws IOException {
        if (this.writePos == CXMLStream.BUFSIZE) {
            this.flushBuffer();
        }
        this.buf[this.writePos++] = (byte)n;
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.writeByte((byte)(bl ? 1 : 0));
    }

    public void writeShort(int n) throws IOException {
        this.writeByte((byte)(n >>> 8 & 0xFF));
        this.writeByte((byte)(n >>> 0 & 0xFF));
    }

    public void writeChar(int n) throws IOException {
        this.writeByte((byte)(n >>> 8 & 0xFF));
        this.writeByte((byte)(n >>> 0 & 0xFF));
    }

    public void writeInt(int n) throws IOException {
        this.writeByte((byte)(n >>> 24 & 0xFF));
        this.writeByte((byte)(n >>> 16 & 0xFF));
        this.writeByte((byte)(n >>> 8 & 0xFF));
        this.writeByte((byte)(n >>> 0 & 0xFF));
    }

    public void writeUTF(char[] cArray, int n, int n2) throws IOException {
        this.writeUTF(new String(cArray, n, n2));
    }

    public void writeUTF(String string) throws IOException {
        char[] cArray;
        int n;
        if (string == null) {
            string = "null";
        }
        if ((n = this.getStrByteSize(cArray = string.toCharArray())) >= 65535) {
            this.writeByte(-1);
            this.writeByte(-1);
            this.writeByte((byte)(n >>> 24 & 0xFF));
            this.writeByte((byte)(n >>> 16 & 0xFF));
            this.writeByte((byte)(n >>> 8 & 0xFF));
            this.writeByte((byte)(n >>> 0 & 0xFF));
        } else {
            this.writeByte((byte)(n >>> 8 & 0xFF));
            this.writeByte((byte)(n >>> 0 & 0xFF));
        }
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= '\u0001' && c <= '\u007f') {
                this.writeByte((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                this.writeByte((byte)(0xE0 | c >> 12 & 0xF));
                this.writeByte((byte)(0x80 | c >> 6 & 0x3F));
                this.writeByte((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            this.writeByte((byte)(0xC0 | c >> 6 & 0x1F));
            this.writeByte((byte)(0x80 | c >> 0 & 0x3F));
        }
    }

    void writeElemQName(QxName qxName) throws IOException {
        this.writeQName(qxName.getQName(), qxName.getNamespaceURI(), true);
    }

    void writeAttrQName(QxName qxName) throws IOException {
        this.writeQName(qxName.getQName(), qxName.getNamespaceURI(), false);
    }

    void writeQName(String string, String string2, boolean bl) throws IOException {
        CXMLCodeSpace cXMLCodeSpace = bl ? this.stream.elemCodeSpace : this.stream.attrCodeSpace;
        byte[] byArray = cXMLCodeSpace.addToken(string);
        if (byArray == null) {
            this.writeByte(bl ? 28 : 25);
            this.writeUTF(string);
            this.tkDefs = Boolean.TRUE;
        } else {
            this.writeByte(bl ? 15 : 24);
            this.writeByte(byArray[1]);
            if (byArray[0] > 1) {
                this.writeByte(byArray[2]);
            }
            if (byArray[0] > 2) {
                this.writeByte(byArray[3]);
            }
        }
        byArray = this.stream.nsCodeSpace.addToken(string2);
        if (byArray == null) {
            this.writeByte(27);
            this.writeUTF(string2);
            this.tkDefs = Boolean.TRUE;
        } else {
            this.writeByte(33);
            this.writeByte(byArray[1]);
        }
    }

    void writeDocument() throws IOException {
        for (int i = 0; i < 4; ++i) {
            this.writeChar(CXMLConstants.cXMLFILE[i]);
        }
        this.writeByte(2);
        if (this.stream.getVersion() != null) {
            this.writeByte(16);
            this.writeUTF(this.stream.getVersion());
            this.writeUTF(this.stream.getEncoding());
            if (this.stream.getStandalone() != null) {
                if (this.stream.getStandalone().equalsIgnoreCase("yes")) {
                    this.writeByte(1);
                } else {
                    this.writeByte(16);
                }
            } else {
                this.writeByte(17);
            }
        }
    }

    void writeTypeInfo(CXMLReader.TypeInfo typeInfo) throws IOException {
    }

    public void close() {
        try {
            this.stream.flush();
            this.writePos = 0;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.stream.returnInfosetWriter(this);
    }

    private int getStrByteSize(char[] cArray) {
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++n;
                continue;
            }
            if (c > '\u07ff') {
                n += 3;
                continue;
            }
            n += 2;
        }
        return n;
    }

    void flushBuffer() throws IOException {
        this.skipOffsets.clear();
        this.stream.flushWriBuffer();
        this.writePos = 0;
        this.buf = this.stream.getWriteBuffer();
    }

    public Object clone() {
        throw new RuntimeException();
    }

    private void clear() {
        this.chdataLen = 0;
        this.flags = 0;
        this.qname = null;
        this.typeinfo.clear();
        this.dtd = null;
    }
}

