/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.xpath.JXPathFunction;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xslt.XSLTContext;

class JXPathContext
implements NSResolver {
    NamespaceContext context;
    XPathFunctionResolver funcResolver;

    JXPathContext(NamespaceContext namespaceContext, XPathFunctionResolver xPathFunctionResolver) {
        this.context = namespaceContext;
        this.funcResolver = xPathFunctionResolver;
    }

    public String resolveNamespacePrefix(String string) {
        return this.context.getNamespaceURI(string);
    }

    OXMLFunction getFunction(String string, String string2, int n) {
        XPathFunction xPathFunction;
        if (this.funcResolver != null && (xPathFunction = this.funcResolver.resolveFunction(new QName(string, string2), n)) != null) {
            return new JXFunction(xPathFunction, string2, n);
        }
        return null;
    }

    class JXFunction
    extends OXMLFunction {
        XPathFunction function;
        String funcName;
        int numArgs;

        JXFunction(XPathFunction xPathFunction, String string, int n) {
            this.function = xPathFunction;
            this.funcName = string;
            this.numArgs = n;
        }

        public String getFunctionName() {
            return this.funcName;
        }

        public int getNumberArgs() {
            return this.numArgs;
        }

        public OXMLSequenceType getReturnType() {
            return OXMLSequenceType.ITEM_ZERO_OR_MORE;
        }

        public OXMLSequenceType getArgType(int n) {
            return OXMLSequenceType.ITEM_ZERO_OR_MORE;
        }

        public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
            ArrayList<Object> arrayList = new ArrayList<Object>(this.numArgs);
            for (int i = 0; i < this.numArgs; ++i) {
                arrayList.add(XPathSequence.getObjectValue(oXMLSequenceArray[i]));
            }
            return this.invoke(arrayList, oXMLFunctionContext);
        }

        public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            arrayList.add(XPathSequence.getObjectValue(oXMLSequence));
            arrayList.add(XPathSequence.getObjectValue(oXMLSequence2));
            return this.invoke(arrayList, oXMLFunctionContext);
        }

        public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(XPathSequence.getObjectValue(oXMLSequence));
            return this.invoke(arrayList, oXMLFunctionContext);
        }

        public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext) throws XQException {
            return this.invoke(null, oXMLFunctionContext);
        }

        private OXMLSequence invoke(List list, OXMLFunctionContext oXMLFunctionContext) throws XQException {
            Object object = null;
            try {
                object = this.function instanceof JXPathFunction ? ((JXPathFunction)((Object)this.function)).evaluate(((XSLTContext)oXMLFunctionContext).getXPathContext(), list) : this.function.evaluate(list);
                OXMLSequence oXMLSequence = oXMLFunctionContext.createSequence();
                if (((XPathSequence)oXMLSequence).setObjectValue(object)) {
                    return oXMLSequence;
                }
                throw new XQException("FOTY0001");
            }
            catch (XPathFunctionException xPathFunctionException) {
                throw new XQException("FOTY0001");
            }
        }
    }
}

