/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.api.record;

import java.util.List;
import java.util.Map;

public interface Schema {
    public Type getType();

    public Schema getElementSchema();

    public List<Entry> getEntries();

    public Map<String, String> getProps();

    public String getProp(String var1);

    public static String sanitizeConnectionName(String name) {
        char[] sanitized;
        if (name.isEmpty()) {
            return name;
        }
        char[] original = name.toCharArray();
        boolean skipFirstChar = !Character.isLetter(original[0]) && original[0] != '_';
        int offset = skipFirstChar ? 1 : 0;
        char[] cArray = sanitized = skipFirstChar ? new char[original.length - offset] : new char[original.length];
        if (!skipFirstChar) {
            sanitized[0] = original[0];
        }
        for (int i = 1; i < original.length; ++i) {
            sanitized[i - offset] = !Character.isLetterOrDigit(original[i]) && original[i] != '_' ? 95 : original[i];
        }
        return new String(sanitized);
    }

    public static interface Builder {
        public Builder withType(Type var1);

        public Builder withEntry(Entry var1);

        public Builder withElementSchema(Schema var1);

        public Builder withProps(Map<String, String> var1);

        public Builder withProp(String var1, String var2);

        public Schema build();
    }

    public static interface Entry {
        public String getName();

        public String getRawName();

        public String getOriginalFieldName();

        public Type getType();

        public boolean isNullable();

        public <T> T getDefaultValue();

        public Schema getElementSchema();

        public String getComment();

        public Map<String, String> getProps();

        public String getProp(String var1);

        public static interface Builder {
            public Builder withName(String var1);

            public Builder withRawName(String var1);

            public Builder withType(Type var1);

            public Builder withNullable(boolean var1);

            public <T> Builder withDefaultValue(T var1);

            public Builder withElementSchema(Schema var1);

            public Builder withComment(String var1);

            public Builder withProps(Map<String, String> var1);

            public Builder withProp(String var1, String var2);

            public Entry build();
        }
    }

    public static enum Type {
        RECORD,
        ARRAY,
        STRING,
        BYTES,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        BOOLEAN,
        DATETIME;

    }
}

