/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.api.record;

import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.talend.sdk.component.api.record.Record;

public interface Schema {
    public Type getType();

    public Schema getElementSchema();

    public List<Entry> getEntries();

    default public Entry getEntry(String name) {
        return Optional.ofNullable(this.getEntries()).orElse(Collections.emptyList()).stream().filter(e -> Objects.equals(e.getName(), name)).findFirst().orElse(null);
    }

    public Map<String, String> getProps();

    public String getProp(String var1);

    public static String sanitizeConnectionName(String name) {
        char[] sanitized;
        if (name.isEmpty()) {
            return name;
        }
        char[] original = name.toCharArray();
        boolean skipFirstChar = !Character.isLetter(original[0]) && original[0] != '_';
        int offset = skipFirstChar ? 1 : 0;
        char[] cArray = sanitized = skipFirstChar ? new char[original.length - offset] : new char[original.length];
        if (!skipFirstChar) {
            sanitized[0] = original[0];
        }
        for (int i = 1; i < original.length; ++i) {
            sanitized[i - offset] = !Character.isLetterOrDigit(original[i]) && original[i] != '_' ? 95 : original[i];
        }
        return new String(sanitized);
    }

    public static interface Builder {
        public Builder withType(Type var1);

        public Builder withEntry(Entry var1);

        public Builder withElementSchema(Schema var1);

        public Builder withProps(Map<String, String> var1);

        public Builder withProp(String var1, String var2);

        public Schema build();
    }

    public static interface Entry {
        public String getName();

        public String getRawName();

        public String getOriginalFieldName();

        public Type getType();

        public boolean isNullable();

        public <T> T getDefaultValue();

        public Schema getElementSchema();

        public String getComment();

        public Map<String, String> getProps();

        public String getProp(String var1);

        public static interface Builder {
            public Builder withName(String var1);

            public Builder withRawName(String var1);

            public Builder withType(Type var1);

            public Builder withNullable(boolean var1);

            public <T> Builder withDefaultValue(T var1);

            public Builder withElementSchema(Schema var1);

            public Builder withComment(String var1);

            public Builder withProps(Map<String, String> var1);

            public Builder withProp(String var1, String var2);

            public Entry build();
        }
    }

    public static enum Type {
        RECORD(new Class[]{Record.class}),
        ARRAY(new Class[]{Collection.class}),
        STRING(new Class[]{String.class}),
        BYTES(new Class[]{byte[].class, Byte[].class}),
        INT(new Class[]{Integer.class}),
        LONG(new Class[]{Long.class}),
        FLOAT(new Class[]{Float.class}),
        DOUBLE(new Class[]{Double.class}),
        BOOLEAN(new Class[]{Boolean.class}),
        DATETIME(new Class[]{Long.class, Date.class, Temporal.class});

        private final Class<?>[] classes;

        private Type(Class<?>[] classes) {
            this.classes = classes;
        }

        public boolean isCompatible(Object input) {
            if (input == null) {
                return true;
            }
            for (Class<?> clazz : this.classes) {
                if (!clazz.isInstance(input)) continue;
                return true;
            }
            return false;
        }
    }
}

