/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.api.record;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class OrderedMap<T> {
    private Node<T> first;
    private Node<T> last;
    private final Map<String, Node<T>> values = new HashMap<String, Node<T>>();
    private final Function<T, String> identifierGetter;

    public OrderedMap(Function<T, String> identifierGetter) {
        this(identifierGetter, Collections.emptyList());
    }

    public OrderedMap(Function<T, String> identifierGetter, Iterable<T> inputValues) {
        this.identifierGetter = identifierGetter;
        inputValues.forEach(this::addValue);
    }

    public Stream<T> streams() {
        if (this.first == null) {
            return Stream.empty();
        }
        Function<Node, Object> tFunction = f -> f.getValue();
        return StreamSupport.stream(this.first.spliterator(), false).map(tFunction);
    }

    public void forEachValue(Consumer<T> valueConsumer) {
        if (this.first != null) {
            this.first.forEach(node -> valueConsumer.accept(node.getValue()));
        }
    }

    public void removeValue(T value) {
        String identifier = this.identifierGetter.apply(value);
        Node<T> node = this.values.remove(identifier);
        if (node == null) {
            throw new IllegalArgumentException("No node '" + identifier + "' expected in values");
        }
        this.removeFromChain(node);
    }

    private void removeFromChain(Node<T> node) {
        if (this.first == node) {
            this.first = node.next;
        }
        if (this.last == node) {
            this.last = node.prec;
        }
        node.remove();
    }

    public T getValue(String identifier) {
        if (this.values != null) {
            return Optional.ofNullable(this.values.get(identifier)).map(Node::getValue).orElse(null);
        }
        return null;
    }

    public void replace(String identifier, T newValue) {
        Node<T> node = this.values.remove(identifier);
        if (node != null) {
            node.value = newValue;
            String newIdentifier = this.identifierGetter.apply(newValue);
            this.values.put(newIdentifier, node);
        }
    }

    public void addValue(T value) {
        String name = this.identifierGetter.apply(value);
        if (this.values != null && this.values.containsKey(name)) {
            return;
        }
        if (this.first == null) {
            this.first = new Node<T>(value, null, null);
            this.last = this.first;
            this.values.put(name, this.first);
        } else {
            Node<T> newNode = this.last.insert(value);
            this.values.put(name, newNode);
            this.last = newNode;
        }
    }

    public void moveAfter(String pivotIdentifier, T valueToMove) {
        Node<T> pivotNode = this.values.get(pivotIdentifier);
        if (pivotNode == null) {
            throw new IllegalArgumentException(String.format("%s not in schema", pivotIdentifier));
        }
        String identifier = this.identifierGetter.apply(valueToMove);
        Node<T> nodeToMove = this.values.get(identifier);
        this.removeFromChain(nodeToMove);
        pivotNode.insert(nodeToMove);
        if (pivotNode == this.last) {
            this.last = nodeToMove;
        }
    }

    public void moveBefore(String pivotIdentifier, T valueToMove) {
        Node<T> nodePivot = this.values.get(pivotIdentifier);
        if (nodePivot == null) {
            throw new IllegalArgumentException(String.format("%s not in schema", pivotIdentifier));
        }
        String newValueName = this.identifierGetter.apply(valueToMove);
        Node<T> nodeToMove = this.values.get(newValueName);
        this.removeFromChain(nodeToMove);
        if (nodePivot == this.first) {
            nodeToMove.next = nodePivot;
            nodePivot.prec = nodeToMove;
            this.first = nodeToMove;
        } else {
            nodePivot.prec.insert(nodeToMove);
        }
    }

    public void swap(String first, String second) {
        if (first == null || second == null || first.equals(second)) {
            return;
        }
        Node<T> firstNode = this.values.get(first);
        if (firstNode == null) {
            throw new IllegalArgumentException(String.format("%s not in schema", first));
        }
        Node<T> secondNode = this.values.get(second);
        if (secondNode == null) {
            throw new IllegalArgumentException(String.format("%s not in schema", secondNode));
        }
        if (firstNode.next == secondNode) {
            firstNode.swapWithNext();
        } else if (secondNode.next == firstNode) {
            secondNode.swapWithNext();
        } else {
            Node firstPrec = firstNode.prec;
            Node firstNext = firstNode.next;
            Node secondPrec = secondNode.prec;
            Node secondNext = secondNode.next;
            firstNode.prec = secondPrec;
            if (secondPrec != null) {
                secondPrec.next = firstNode;
            }
            firstNode.next = secondNext;
            if (secondNext != null) {
                secondNext.prec = firstNode;
            }
            secondNode.prec = firstPrec;
            if (firstPrec != null) {
                firstPrec.next = secondNode;
            }
            secondNode.next = firstNext;
            if (firstNext != null) {
                firstNext.prec = secondNode;
            }
        }
        if (this.first == firstNode) {
            this.first = secondNode;
        } else if (this.first == secondNode) {
            this.first = firstNode;
        }
        if (this.last == firstNode) {
            this.last = secondNode;
        } else if (this.last == secondNode) {
            this.last = firstNode;
        }
    }

    static class Node<T>
    implements Iterable<Node<T>> {
        public T value;
        public Node<T> next;
        public Node<T> prec;

        public Node<T> insert(T newValue) {
            Node<T> newNode = new Node<T>(newValue, this.next, this);
            return this.insert(newNode);
        }

        public Node<T> insert(Node<T> newNode) {
            if (newNode == this) {
                return newNode;
            }
            if (this.next != null) {
                this.next.prec = newNode;
            }
            newNode.prec = this;
            newNode.next = this.next;
            this.next = newNode;
            return newNode;
        }

        public void remove() {
            if (this.next != null) {
                this.next.prec = this.prec;
            }
            if (this.prec != null) {
                this.prec.next = this.next;
            }
            this.next = null;
            this.prec = null;
        }

        public void swapWithNext() {
            Node<T> nextNode = this.next;
            if (nextNode == null) {
                return;
            }
            Node<T> firstPrec = this.prec;
            Node<T> nextNext = nextNode.next;
            nextNode.next = this;
            nextNode.prec = this.prec;
            if (firstPrec != null) {
                firstPrec.next = nextNode;
            }
            this.prec = nextNode;
            this.next = nextNext;
            if (nextNext != null) {
                nextNext.prec = this;
            }
        }

        @Override
        public Iterator<Node<T>> iterator() {
            return new NodeIterator(this);
        }

        public Node(T value, Node<T> next, Node<T> prec) {
            this.value = value;
            this.next = next;
            this.prec = prec;
        }

        public T getValue() {
            return this.value;
        }

        static class NodeIterator<T>
        implements Iterator<Node<T>> {
            private Node<T> current;

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public Node<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("no further node");
                }
                Node<T> next = this.current;
                this.current = next.next;
                return next;
            }

            public NodeIterator(Node<T> current) {
                this.current = current;
            }
        }
    }
}

