/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.api.record;

import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonValue;
import javax.json.bind.annotation.JsonbTransient;
import javax.json.stream.JsonParser;
import org.talend.sdk.component.api.record.OrderedMap;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.SchemaProperty;

public interface Schema {
    public static final String SKIP_SANITIZE_PROPERTY = "talend.component.record.skip.sanitize";
    public static final boolean SKIP_SANITIZE = Boolean.getBoolean("talend.component.record.skip.sanitize");

    public Type getType();

    public Schema getElementSchema();

    public List<Entry> getEntries();

    public List<Entry> getMetadata();

    public Stream<Entry> getAllEntries();

    default public Map<String, Entry> getEntryMap() {
        throw new UnsupportedOperationException("#getEntryMap is not implemented");
    }

    default public Builder toBuilder() {
        throw new UnsupportedOperationException("#toBuilder is not implemented");
    }

    default public List<Entry> getEntriesOrdered() {
        return this.getEntriesOrdered(this.naturalOrder());
    }

    @JsonbTransient
    default public List<Entry> getEntriesOrdered(Comparator<Entry> comparator) {
        return this.getAllEntries().sorted(comparator).collect(Collectors.toList());
    }

    default public EntriesOrder naturalOrder() {
        throw new UnsupportedOperationException("#naturalOrder is not implemented");
    }

    default public Entry getEntry(String name) {
        return this.getEntryMap().get(name);
    }

    public Map<String, String> getProps();

    public String getProp(String var1);

    /*
     * Enabled aggressive exception aggregation
     */
    default public JsonValue getJsonProp(String name) {
        String prop = this.getProp(name);
        if (prop == null) {
            return null;
        }
        try (StringReader reader = new StringReader(prop);){
            JsonValue jsonValue;
            block14: {
                JsonParser parser = Json.createParser((Reader)reader);
                try {
                    jsonValue = parser.getValue();
                    if (parser == null) break block14;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return jsonValue;
        }
        catch (RuntimeException ex) {
            return Json.createValue((String)prop);
        }
    }

    public static String sanitizeConnectionName(String name) {
        if (SKIP_SANITIZE || name == null || name.isEmpty()) {
            return name;
        }
        char current = name.charAt(0);
        CharsetEncoder ascii = Charset.forName(StandardCharsets.US_ASCII.name()).newEncoder();
        boolean skipFirstChar = (!ascii.canEncode(current) || !Character.isLetter(current) && current != '_') && name.length() > 1 && !Character.isDigit(name.charAt(1));
        StringBuilder sanitizedBuilder = new StringBuilder();
        if (!skipFirstChar) {
            if (!Character.isLetter(current) && current != '_' || !ascii.canEncode(current)) {
                sanitizedBuilder.append('_');
            } else {
                sanitizedBuilder.append(current);
            }
        }
        for (int i = 1; i < name.length(); ++i) {
            current = name.charAt(i);
            if (!ascii.canEncode(current)) {
                if (Character.isLowerCase(current) || Character.isUpperCase(current)) {
                    sanitizedBuilder.append('_');
                    continue;
                }
                byte[] encoded = Base64.getEncoder().encode(name.substring(i, i + 1).getBytes(StandardCharsets.UTF_8));
                String enc = new String(encoded);
                if (sanitizedBuilder.length() == 0 && Character.isDigit(enc.charAt(0))) {
                    sanitizedBuilder.append('_');
                }
                for (int iter = 0; iter < enc.length(); ++iter) {
                    if (Character.isLetterOrDigit(enc.charAt(iter))) {
                        sanitizedBuilder.append(enc.charAt(iter));
                        continue;
                    }
                    sanitizedBuilder.append('_');
                }
                continue;
            }
            if (Character.isLetterOrDigit(current)) {
                sanitizedBuilder.append(current);
                continue;
            }
            sanitizedBuilder.append('_');
        }
        return sanitizedBuilder.toString();
    }

    public static Entry avoidCollision(Entry newEntry, Function<String, Entry> entryGetter, BiConsumer<String, Entry> replaceFunction) {
        boolean matchedToChange;
        if (SKIP_SANITIZE) {
            return newEntry;
        }
        Optional<Entry> collisionedEntry = Optional.ofNullable(entryGetter.apply(newEntry.getName())).filter(field -> !Objects.equals(field, newEntry));
        if (!collisionedEntry.isPresent()) {
            return newEntry;
        }
        Entry matchedEntry = collisionedEntry.get();
        boolean bl = matchedToChange = matchedEntry.getRawName() != null && !matchedEntry.getRawName().isEmpty();
        if (matchedToChange) {
            replaceFunction.accept(matchedEntry.getName(), newEntry);
        } else if (newEntry.getRawName() == null || newEntry.getRawName().isEmpty()) {
            return null;
        }
        Entry fieldToChange = matchedToChange ? matchedEntry : newEntry;
        int indexForAnticollision = 1;
        String baseName = Schema.sanitizeConnectionName(fieldToChange.getRawName());
        String newName = baseName + "_" + indexForAnticollision;
        while (entryGetter.apply(newName) != null) {
            newName = baseName + "_" + ++indexForAnticollision;
        }
        Entry newFieldToAdd = fieldToChange.toBuilder().withName(newName).build();
        return newFieldToAdd;
    }

    public static class EntriesOrder
    implements Comparator<Entry> {
        private final OrderedMap<String> fieldsOrder;
        private Comparator<Entry> currentComparator = null;

        public static EntriesOrder of(String fields) {
            return new EntriesOrder(fields);
        }

        public static EntriesOrder of(Iterable<String> fields) {
            OrderedMap<String> orders = new OrderedMap<String>(Function.identity(), fields);
            return new EntriesOrder(orders);
        }

        public EntriesOrder(String fields) {
            if (fields == null || fields.isEmpty()) {
                this.fieldsOrder = new OrderedMap(Function.identity());
            } else {
                List fieldList = Arrays.stream(fields.split(",")).collect(Collectors.toList());
                this.fieldsOrder = new OrderedMap(Function.identity(), fieldList);
            }
        }

        public EntriesOrder(Iterable<String> fields) {
            this(new OrderedMap<String>(Function.identity(), fields));
        }

        public Stream<String> getFieldsOrder() {
            return this.fieldsOrder.streams();
        }

        public EntriesOrder moveAfter(String after, String name) {
            this.currentComparator = null;
            this.fieldsOrder.moveAfter(after, name);
            return this;
        }

        public EntriesOrder moveBefore(String before, String name) {
            this.currentComparator = null;
            this.fieldsOrder.moveBefore(before, name);
            return this;
        }

        public EntriesOrder swap(String name, String with) {
            this.currentComparator = null;
            this.fieldsOrder.swap(name, with);
            return this;
        }

        public String toFields() {
            return this.fieldsOrder.streams().collect(Collectors.joining(","));
        }

        public Comparator<Entry> getComparator() {
            if (this.currentComparator == null) {
                HashMap<String, Integer> entryPositions = new HashMap<String, Integer>();
                AtomicInteger index = new AtomicInteger(1);
                this.fieldsOrder.streams().forEach(name -> entryPositions.put((String)name, index.getAndIncrement()));
                this.currentComparator = new EntryComparator(entryPositions);
            }
            return this.currentComparator;
        }

        @Override
        public int compare(Entry e1, Entry e2) {
            return this.getComparator().compare(e1, e2);
        }

        public EntriesOrder(OrderedMap<String> fieldsOrder) {
            this.fieldsOrder = fieldsOrder;
        }

        public String toString() {
            return "Schema.EntriesOrder(fieldsOrder=" + this.getFieldsOrder() + ", currentComparator=" + this.currentComparator + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntriesOrder)) {
                return false;
            }
            EntriesOrder other = (EntriesOrder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Stream<String> this$fieldsOrder = this.getFieldsOrder();
            Stream<String> other$fieldsOrder = other.getFieldsOrder();
            if (this$fieldsOrder == null ? other$fieldsOrder != null : !this$fieldsOrder.equals(other$fieldsOrder)) {
                return false;
            }
            Comparator<Entry> this$currentComparator = this.currentComparator;
            Comparator<Entry> other$currentComparator = other.currentComparator;
            return !(this$currentComparator == null ? other$currentComparator != null : !((Object)this$currentComparator).equals(other$currentComparator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EntriesOrder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Stream<String> $fieldsOrder = this.getFieldsOrder();
            result = result * 59 + ($fieldsOrder == null ? 43 : $fieldsOrder.hashCode());
            Comparator<Entry> $currentComparator = this.currentComparator;
            result = result * 59 + ($currentComparator == null ? 43 : $currentComparator.hashCode());
            return result;
        }

        static class EntryComparator
        implements Comparator<Entry> {
            private final Map<String, Integer> entryPositions;

            @Override
            public int compare(Entry e1, Entry e2) {
                int index1 = this.entryPositions.getOrDefault(e1.getName(), Integer.MAX_VALUE);
                int index2 = this.entryPositions.getOrDefault(e2.getName(), Integer.MAX_VALUE);
                if (index1 >= 0 && index2 >= 0) {
                    return index1 - index2;
                }
                if (index1 >= 0) {
                    return -1;
                }
                if (index2 >= 0) {
                    return 1;
                }
                return 0;
            }

            public EntryComparator(Map<String, Integer> entryPositions) {
                this.entryPositions = entryPositions;
            }
        }
    }

    public static interface Entry {
        public String getName();

        public String getRawName();

        public String getOriginalFieldName();

        public Type getType();

        public boolean isNullable();

        public boolean isMetadata();

        public boolean isErrorCapable();

        public boolean isValid();

        public <T> T getDefaultValue();

        public Schema getElementSchema();

        public String getComment();

        public Map<String, String> getProps();

        public String getProp(String var1);

        /*
         * Enabled aggressive exception aggregation
         */
        default public JsonValue getJsonProp(String name) {
            String prop = this.getProp(name);
            if (prop == null) {
                return null;
            }
            try (StringReader reader = new StringReader(prop);){
                JsonValue jsonValue;
                block14: {
                    JsonParser parser = Json.createParser((Reader)reader);
                    try {
                        jsonValue = parser.getValue();
                        if (parser == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    parser.close();
                }
                return jsonValue;
            }
            catch (RuntimeException ex) {
                return Json.createValue((String)prop);
            }
        }

        default public String getLogicalType() {
            return this.getProp("field.logical.type");
        }

        default public Builder toBuilder() {
            throw new UnsupportedOperationException("#toBuilder is not implemented");
        }

        default public String getErrorMessage() {
            return this.getProp("record.value.on.error.message");
        }

        default public String getErrorFallbackValue() {
            return this.getProp("record.value.on.error.fallback_value");
        }

        public static interface Builder {
            public Builder withName(String var1);

            public Builder withRawName(String var1);

            public Builder withType(Type var1);

            default public Builder withLogicalType(SchemaProperty.LogicalType logicalType) {
                throw new UnsupportedOperationException("#withLogicalType is not implemented");
            }

            default public Builder withLogicalType(String logicalType) {
                throw new UnsupportedOperationException("#withLogicalType is not implemented");
            }

            public Builder withNullable(boolean var1);

            public Builder withErrorCapable(boolean var1);

            public Builder withMetadata(boolean var1);

            public <T> Builder withDefaultValue(T var1);

            public Builder withElementSchema(Schema var1);

            public Builder withComment(String var1);

            public Builder withProps(Map<String, String> var1);

            public Builder withProp(String var1, String var2);

            public Entry build();
        }
    }

    public static interface Builder {
        public Builder withType(Type var1);

        public Builder withEntry(Entry var1);

        default public Builder withEntryAfter(String after, Entry entry) {
            throw new UnsupportedOperationException("#withEntryAfter is not implemented");
        }

        default public Builder withEntryBefore(String before, Entry entry) {
            throw new UnsupportedOperationException("#withEntryBefore is not implemented");
        }

        default public Builder remove(String name) {
            throw new UnsupportedOperationException("#remove is not implemented");
        }

        default public Builder remove(Entry entry) {
            throw new UnsupportedOperationException("#remove is not implemented");
        }

        default public Builder moveAfter(String after, String name) {
            throw new UnsupportedOperationException("#moveAfter is not implemented");
        }

        default public Builder moveBefore(String before, String name) {
            throw new UnsupportedOperationException("#moveBefore is not implemented");
        }

        default public Builder swap(String name, String with) {
            throw new UnsupportedOperationException("#swap is not implemented");
        }

        public Builder withElementSchema(Schema var1);

        public Builder withProps(Map<String, String> var1);

        public Builder withProp(String var1, String var2);

        public Schema build();

        default public Schema build(Comparator<Entry> order) {
            throw new UnsupportedOperationException("#build(EntriesOrder) is not implemented");
        }
    }

    public static enum Type {
        RECORD(new Class[]{Record.class}),
        ARRAY(new Class[]{Collection.class}),
        STRING(new Class[]{String.class, Object.class}),
        BYTES(new Class[]{byte[].class, Byte[].class}),
        INT(new Class[]{Integer.class}),
        LONG(new Class[]{Long.class}),
        FLOAT(new Class[]{Float.class}),
        DOUBLE(new Class[]{Double.class}),
        BOOLEAN(new Class[]{Boolean.class}),
        DATETIME(new Class[]{Long.class, Date.class, Temporal.class}),
        DECIMAL(new Class[]{BigDecimal.class});

        private final Class<?>[] classes;

        private Type(Class<?>[] classes) {
            this.classes = classes;
        }

        public boolean isCompatible(Object input) {
            if (input == null) {
                return true;
            }
            for (Class<?> clazz : this.classes) {
                if (!clazz.isInstance(input)) continue;
                return true;
            }
            return false;
        }
    }
}

