/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.json.bind.annotation.JsonbProperty;
import javax.json.bind.annotation.JsonbVisibility;
import javax.json.bind.config.PropertyVisibilityStrategy;
import org.apache.johnzon.mapper.Cleanable;
import org.apache.johnzon.mapper.util.BeanUtil;

class DefaultPropertyVisibilityStrategy
implements PropertyVisibilityStrategy,
Cleanable<Class<?>> {
    private final ConcurrentMap<Class<?>, PropertyVisibilityStrategy> strategies = new ConcurrentHashMap();
    private volatile boolean skipGetpackage;

    DefaultPropertyVisibilityStrategy() {
    }

    @Override
    public boolean isVisible(Field field) {
        return this.isVisible(field, field.getDeclaringClass(), true);
    }

    public boolean isVisible(Field field, Class<?> root, boolean useGetter) {
        if (field.getAnnotation(JsonbProperty.class) != null) {
            return true;
        }
        PropertyVisibilityStrategy strategy = this.strategies.computeIfAbsent(root, this::visibilityStrategy);
        return strategy == this ? this.isFieldVisible(field, root, useGetter) : strategy.isVisible(field);
    }

    private boolean isFieldVisible(Field field, Class<?> root, boolean useGetter) {
        if (!Modifier.isPublic(field.getModifiers())) {
            return false;
        }
        if (!useGetter) {
            return !this.hasMethod(root, BeanUtil.setterName(field.getName()), new Class[0]);
        }
        String capitalizedName = BeanUtil.capitalize(field.getName());
        return !this.hasMethod(root, "get" + capitalizedName, new Class[0]) || this.hasMethod(root, "is" + capitalizedName, new Class[0]);
    }

    private boolean hasMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        try {
            clazz.getDeclaredMethod(methodName, paramTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            Class<?> superclass = clazz.getSuperclass();
            if (superclass == Object.class) {
                return false;
            }
            return this.hasMethod(superclass, methodName, paramTypes);
        }
    }

    @Override
    public boolean isVisible(Method method) {
        PropertyVisibilityStrategy strategy = this.strategies.computeIfAbsent(method.getDeclaringClass(), this::visibilityStrategy);
        return strategy == this ? Modifier.isPublic(method.getModifiers()) : strategy.isVisible(method);
    }

    private PropertyVisibilityStrategy visibilityStrategy(Class<?> type) {
        JsonbVisibility visibility = type.getAnnotation(JsonbVisibility.class);
        if (visibility != null) {
            try {
                return visibility.value().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Package p = type.getPackage();
        while (p != null) {
            visibility = p.getAnnotation(JsonbVisibility.class);
            if (visibility != null) {
                try {
                    return visibility.value().newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            String name = p.getName();
            int end = name.lastIndexOf(46);
            if (end < 0) break;
            p = null;
            String parentPack = name.substring(0, end);
            if (!this.skipGetpackage) {
                try {
                    p = Package.getPackage(parentPack);
                }
                catch (Error unsupported) {
                    this.skipGetpackage = true;
                }
            }
            if (p != null) continue;
            try {
                p = Optional.ofNullable(type.getClassLoader()).orElseGet(ClassLoader::getSystemClassLoader).loadClass(parentPack + ".package-info").getPackage();
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return this;
    }

    @Override
    public void clean(Class<?> clazz) {
        this.strategies.remove(clazz);
    }
}

