/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb.converter;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.json.bind.annotation.JsonbDateFormat;
import org.apache.johnzon.jsonb.converter.JsonbDateConverterBase;

public class JsonbDateConverter
extends JsonbDateConverterBase<Date> {
    private static final ZoneId UTC = ZoneId.of("UTC");
    private volatile boolean hasTimezone = true;
    private volatile boolean isIso = false;

    public JsonbDateConverter(JsonbDateFormat dateFormat) {
        super(dateFormat);
    }

    @Override
    public String toString(Date instance) {
        return this.formatter == null ? Long.toString(instance.getTime()) : this.toStringWithFormatter(instance);
    }

    @Override
    public Date fromString(String text) {
        return this.formatter == null ? new Date(Long.parseLong(text)) : this.fromStringWithFormatter(text);
    }

    private Date fromStringWithFormatter(String text) {
        boolean hasTimezone = this.hasTimezone;
        boolean isIso = this.isIso;
        try {
            if (isIso) {
                return this.fromIso(text);
            }
            if (hasTimezone) {
                return this.fromZonedDateTime(text);
            }
            return this.fromLocalDateTime(text);
        }
        catch (DateTimeException dte) {
            this.hasTimezone = !hasTimezone;
            try {
                if (hasTimezone) {
                    return this.fromLocalDateTime(text);
                }
                return this.fromZonedDateTime(text);
            }
            catch (DateTimeException dte2) {
                Date from = this.fromIso(text);
                this.isIso = !isIso;
                return from;
            }
        }
    }

    private Date fromIso(String text) {
        return Date.from(ZonedDateTime.parse(text, DateTimeFormatter.ISO_ZONED_DATE_TIME).toInstant());
    }

    private String toStringWithFormatter(Date instance) {
        boolean hasTimezone = this.hasTimezone;
        boolean isIso = this.isIso;
        Instant instant = Instant.ofEpochMilli(instance.getTime());
        try {
            if (isIso) {
                return this.toIsoString(instant);
            }
            if (hasTimezone) {
                return this.toStringFromZonedDateTime(instant);
            }
            return this.toStringFromLocalDateTime(instant);
        }
        catch (DateTimeException dte) {
            try {
                boolean bl = this.hasTimezone = !hasTimezone;
                if (hasTimezone) {
                    return this.toStringFromLocalDateTime(instant);
                }
                return this.toStringFromZonedDateTime(instant);
            }
            catch (DateTimeException dte2) {
                this.isIso = !isIso;
                return this.toIsoString(instant);
            }
        }
    }

    private String toIsoString(Instant instant) {
        return DateTimeFormatter.ISO_ZONED_DATE_TIME.format(ZonedDateTime.ofInstant(instant, UTC));
    }

    private Date fromLocalDateTime(String text) {
        return Date.from(LocalDateTime.parse(text, this.formatter).toInstant(ZoneOffset.UTC));
    }

    private Date fromZonedDateTime(String text) {
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(text, this.formatter);
        return Date.from(zonedDateTime.toInstant());
    }

    private String toStringFromLocalDateTime(Instant instant) {
        return this.formatter.format(LocalDateTime.ofInstant(instant, UTC));
    }

    private String toStringFromZonedDateTime(Instant instant) {
        return this.formatter.format(ZonedDateTime.ofInstant(instant, UTC));
    }
}

