/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.input;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.service.configuration.LocalConfiguration;
import org.talend.sdk.component.runtime.serialization.ContainerFinder;

public class Streaming {
    private static final Logger log = LoggerFactory.getLogger(Streaming.class);
    public static final int MAX_DURATION_TIME_MS_GRACE_PERIOD = 3000;
    private static Supplier<LocalConfiguration> defaultLocalConfiguration = () -> new LocalConfiguration(){

        @Override
        public String get(String key) {
            return null;
        }

        @Override
        public Set<String> keys() {
            return Collections.emptySet();
        }
    };

    public static RetryConfiguration loadRetryConfiguration(String plugin) {
        LocalConfiguration configuration = Optional.ofNullable(ContainerFinder.Instance.get().find(plugin)).map(it -> it.findService(LocalConfiguration.class)).orElseGet(defaultLocalConfiguration);
        int maxRetries = Optional.ofNullable(configuration.get("talend.input.streaming.retry.maxRetries")).map(Integer::parseInt).orElse(Integer.MAX_VALUE);
        return new RetryConfiguration(maxRetries, Streaming.getStrategy(configuration));
    }

    public static RetryStrategy getStrategy(LocalConfiguration configuration) {
        switch (Optional.ofNullable(configuration.get("talend.input.streaming.retry.strategy")).orElse("constant")) {
            case "exponential": {
                return new RetryConfiguration.ExponentialBackoff(Optional.ofNullable(configuration.get("talend.input.streaming.retry.exponential.exponent")).map(Double::parseDouble).orElse(1.5), Optional.ofNullable(configuration.get("talend.input.streaming.retry.exponential.randomizationFactor")).map(Double::parseDouble).orElse(0.5), Optional.ofNullable(configuration.get("talend.input.streaming.retry.exponential.maxDuration")).map(Long::parseLong).orElse(TimeUnit.MINUTES.toMillis(5L)), Optional.ofNullable(configuration.get("talend.input.streaming.retry.exponential.initialBackOff")).map(Long::parseLong).orElse(TimeUnit.SECONDS.toMillis(1L)), 0);
            }
        }
        return new RetryConfiguration.Constant(Optional.ofNullable(configuration.get("talend.input.streaming.retry.constant.timeout")).map(Long::parseLong).orElse(500L));
    }

    public static StopStrategy loadStopStrategy(String plugin, Map<String, String> internalConfiguration) {
        LocalConfiguration configuration = Optional.ofNullable(ContainerFinder.Instance.get().find(plugin)).map(it -> it.findService(LocalConfiguration.class)).orElseGet(defaultLocalConfiguration);
        Long maxReadRecords = Optional.ofNullable(internalConfiguration.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("$maxRecords") || ((String)e.getKey()).contains(".$maxRecords")).findFirst().map(e -> (String)e.getValue()).map(Long::parseLong)).get().orElseGet(() -> Optional.ofNullable(System.getProperty(String.format("%s.talend.input.streaming.maxRecords", plugin))).map(Long::parseLong).orElseGet(() -> Optional.ofNullable(configuration.get("talend.input.streaming.maxRecords")).map(Long::parseLong).orElseGet(() -> null)));
        Long maxActiveTime = Optional.ofNullable(internalConfiguration.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("$maxDurationMs") || ((String)e.getKey()).contains(".$maxDurationMs")).findFirst().map(e -> (String)e.getValue()).map(Long::parseLong)).get().orElseGet(() -> Optional.ofNullable(System.getProperty(String.format("%s.talend.input.streaming.maxDurationMs", plugin))).map(Long::parseLong).orElseGet(() -> Optional.ofNullable(configuration.get("talend.input.streaming.maxDurationMs")).map(Long::parseLong).orElseGet(() -> null)));
        log.debug("[loadStopStrategy] Records: {}; Duration: {}.", (Object)maxReadRecords, (Object)maxActiveTime);
        return new StopConfiguration(maxReadRecords, maxActiveTime, null);
    }

    public static class RetryConfiguration
    implements Serializable {
        private int maxRetries;
        private RetryStrategy strategy;

        public int getMaxRetries() {
            return this.maxRetries;
        }

        public RetryStrategy getStrategy() {
            return this.strategy;
        }

        public void setMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
        }

        public void setStrategy(RetryStrategy strategy) {
            this.strategy = strategy;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RetryConfiguration)) {
                return false;
            }
            RetryConfiguration other = (RetryConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxRetries() != other.getMaxRetries()) {
                return false;
            }
            RetryStrategy this$strategy = this.getStrategy();
            RetryStrategy other$strategy = other.getStrategy();
            return !(this$strategy == null ? other$strategy != null : !this$strategy.equals(other$strategy));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RetryConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxRetries();
            RetryStrategy $strategy = this.getStrategy();
            result = result * 59 + ($strategy == null ? 43 : $strategy.hashCode());
            return result;
        }

        public String toString() {
            return "Streaming.RetryConfiguration(maxRetries=" + this.getMaxRetries() + ", strategy=" + this.getStrategy() + ")";
        }

        public RetryConfiguration() {
        }

        public RetryConfiguration(int maxRetries, RetryStrategy strategy) {
            this.maxRetries = maxRetries;
            this.strategy = strategy;
        }

        public static class ExponentialBackoff
        implements Serializable,
        RetryStrategy {
            private double exponent;
            private double randomizationFactor;
            private long max;
            private long initialBackOff;
            private int iteration;

            @Override
            public long nextPauseDuration() {
                double currentIntervalMillis = Math.min((double)this.initialBackOff * Math.pow(this.exponent, this.iteration), (double)this.max);
                double randomOffset = (Math.random() * 2.0 - 1.0) * this.randomizationFactor * currentIntervalMillis;
                long nextBackoffMillis = Math.min(this.max, Math.round(currentIntervalMillis + randomOffset));
                ++this.iteration;
                return nextBackoffMillis;
            }

            @Override
            public void reset() {
                this.iteration = 0;
            }

            public double getExponent() {
                return this.exponent;
            }

            public double getRandomizationFactor() {
                return this.randomizationFactor;
            }

            public long getMax() {
                return this.max;
            }

            public long getInitialBackOff() {
                return this.initialBackOff;
            }

            public int getIteration() {
                return this.iteration;
            }

            public void setExponent(double exponent) {
                this.exponent = exponent;
            }

            public void setRandomizationFactor(double randomizationFactor) {
                this.randomizationFactor = randomizationFactor;
            }

            public void setMax(long max) {
                this.max = max;
            }

            public void setInitialBackOff(long initialBackOff) {
                this.initialBackOff = initialBackOff;
            }

            public void setIteration(int iteration) {
                this.iteration = iteration;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ExponentialBackoff)) {
                    return false;
                }
                ExponentialBackoff other = (ExponentialBackoff)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (Double.compare(this.getExponent(), other.getExponent()) != 0) {
                    return false;
                }
                if (Double.compare(this.getRandomizationFactor(), other.getRandomizationFactor()) != 0) {
                    return false;
                }
                if (this.getMax() != other.getMax()) {
                    return false;
                }
                if (this.getInitialBackOff() != other.getInitialBackOff()) {
                    return false;
                }
                return this.getIteration() == other.getIteration();
            }

            protected boolean canEqual(Object other) {
                return other instanceof ExponentialBackoff;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $exponent = Double.doubleToLongBits(this.getExponent());
                result = result * 59 + (int)($exponent >>> 32 ^ $exponent);
                long $randomizationFactor = Double.doubleToLongBits(this.getRandomizationFactor());
                result = result * 59 + (int)($randomizationFactor >>> 32 ^ $randomizationFactor);
                long $max = this.getMax();
                result = result * 59 + (int)($max >>> 32 ^ $max);
                long $initialBackOff = this.getInitialBackOff();
                result = result * 59 + (int)($initialBackOff >>> 32 ^ $initialBackOff);
                result = result * 59 + this.getIteration();
                return result;
            }

            public String toString() {
                return "Streaming.RetryConfiguration.ExponentialBackoff(exponent=" + this.getExponent() + ", randomizationFactor=" + this.getRandomizationFactor() + ", max=" + this.getMax() + ", initialBackOff=" + this.getInitialBackOff() + ", iteration=" + this.getIteration() + ")";
            }

            public ExponentialBackoff() {
            }

            public ExponentialBackoff(double exponent, double randomizationFactor, long max, long initialBackOff, int iteration) {
                this.exponent = exponent;
                this.randomizationFactor = randomizationFactor;
                this.max = max;
                this.initialBackOff = initialBackOff;
                this.iteration = iteration;
            }
        }

        public static class Constant
        implements Serializable,
        RetryStrategy {
            private long timeout;

            @Override
            public long nextPauseDuration() {
                return this.timeout;
            }

            @Override
            public void reset() {
            }

            public long getTimeout() {
                return this.timeout;
            }

            public void setTimeout(long timeout) {
                this.timeout = timeout;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Constant)) {
                    return false;
                }
                Constant other = (Constant)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return this.getTimeout() == other.getTimeout();
            }

            protected boolean canEqual(Object other) {
                return other instanceof Constant;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $timeout = this.getTimeout();
                result = result * 59 + (int)($timeout >>> 32 ^ $timeout);
                return result;
            }

            public String toString() {
                return "Streaming.RetryConfiguration.Constant(timeout=" + this.getTimeout() + ")";
            }

            public Constant() {
            }

            public Constant(long timeout) {
                this.timeout = timeout;
            }
        }
    }

    public static interface RetryStrategy {
        public long nextPauseDuration();

        public void reset();
    }

    public static class StopConfiguration
    implements StopStrategy,
    Serializable {
        private long maxReadRecords;
        private long maxActiveTime;
        private long startedAtTime;

        public StopConfiguration() {
            this.maxReadRecords = -1L;
            this.maxActiveTime = -1L;
            this.startedAtTime = System.currentTimeMillis();
        }

        public StopConfiguration(Long maxRecords, Long maxTime, Long start) {
            this.maxReadRecords = maxRecords == null ? -1L : maxRecords;
            this.maxActiveTime = maxTime == null ? -1L : maxTime;
            this.startedAtTime = start == null ? System.currentTimeMillis() : start;
        }

        @Override
        public boolean isActive() {
            return this.maxReadRecords > -1L || this.maxActiveTime > -1L;
        }

        private boolean hasEnoughRecords(long read) {
            return this.maxReadRecords != -1L && read >= this.maxReadRecords;
        }

        private boolean isTimePassed() {
            return this.maxActiveTime != -1L && System.currentTimeMillis() - this.startedAtTime >= this.maxActiveTime;
        }

        @Override
        public boolean shouldStop(long readRecords) {
            return this.hasEnoughRecords(readRecords) || this.isTimePassed();
        }

        @Override
        public long getMaxReadRecords() {
            return this.maxReadRecords;
        }

        @Override
        public long getMaxActiveTime() {
            return this.maxActiveTime;
        }

        @Override
        public long getStartedAtTime() {
            return this.startedAtTime;
        }

        public void setMaxReadRecords(long maxReadRecords) {
            this.maxReadRecords = maxReadRecords;
        }

        public void setMaxActiveTime(long maxActiveTime) {
            this.maxActiveTime = maxActiveTime;
        }

        public void setStartedAtTime(long startedAtTime) {
            this.startedAtTime = startedAtTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StopConfiguration)) {
                return false;
            }
            StopConfiguration other = (StopConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxReadRecords() != other.getMaxReadRecords()) {
                return false;
            }
            if (this.getMaxActiveTime() != other.getMaxActiveTime()) {
                return false;
            }
            return this.getStartedAtTime() == other.getStartedAtTime();
        }

        protected boolean canEqual(Object other) {
            return other instanceof StopConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $maxReadRecords = this.getMaxReadRecords();
            result = result * 59 + (int)($maxReadRecords >>> 32 ^ $maxReadRecords);
            long $maxActiveTime = this.getMaxActiveTime();
            result = result * 59 + (int)($maxActiveTime >>> 32 ^ $maxActiveTime);
            long $startedAtTime = this.getStartedAtTime();
            result = result * 59 + (int)($startedAtTime >>> 32 ^ $startedAtTime);
            return result;
        }

        public String toString() {
            return "Streaming.StopConfiguration(maxReadRecords=" + this.getMaxReadRecords() + ", maxActiveTime=" + this.getMaxActiveTime() + ", startedAtTime=" + this.getStartedAtTime() + ")";
        }
    }

    public static interface StopStrategy {
        public boolean isActive();

        public boolean shouldStop(long var1);

        public long getMaxReadRecords();

        public long getMaxActiveTime();

        public long getStartedAtTime();
    }
}

