/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.talend.sdk.component.api.component.ReturnVariables;
import org.talend.sdk.component.api.input.Emitter;
import org.talend.sdk.component.api.input.PartitionMapper;
import org.talend.sdk.component.api.processor.Processor;
import org.talend.sdk.component.api.standalone.DriverRunner;
import org.talend.sdk.component.spi.component.ComponentMetadataEnricher;

public class ReturnVariableMetadataEnricher
implements ComponentMetadataEnricher {
    private static final Set<Class<? extends Annotation>> SUPPORTED_ANNOTATIONS = new HashSet<Class>(Arrays.asList(PartitionMapper.class, Emitter.class, Processor.class, DriverRunner.class));
    public static final String META_KEY_RETURN_VARIABLE = "variables::return::value";
    private static final String VALUE_DELIMITER = "\\:";
    private static final String LINE_DELIMITER = "\\;";

    @Override
    public Map<String, String> onComponent(Type type, Annotation[] annotations) {
        boolean noneMatch = Stream.of(annotations).map(Annotation::annotationType).noneMatch(SUPPORTED_ANNOTATIONS::contains);
        if (noneMatch) {
            return Collections.emptyMap();
        }
        String returnVariableMetaValue = Stream.concat(Stream.of(annotations), Stream.of(annotations).filter(a -> a.annotationType().equals(ReturnVariables.class)).map(ReturnVariables.class::cast).map(ReturnVariables::value).flatMap(Stream::of)).filter(a -> a.annotationType().equals(ReturnVariables.ReturnVariable.class)).map(ReturnVariables.ReturnVariable.class::cast).map(ReturnVariableMetadataEnricher::makeReturnVariableString).collect(Collectors.joining(LINE_DELIMITER));
        if (returnVariableMetaValue.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(META_KEY_RETURN_VARIABLE, returnVariableMetaValue);
    }

    private static String makeReturnVariableString(ReturnVariables.ReturnVariable var) {
        return var.value() + VALUE_DELIMITER + var.type().getCanonicalName() + VALUE_DELIMITER + var.availability().getKey() + VALUE_DELIMITER + var.description();
    }
}

