/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.interceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.talend.sdk.component.api.service.cache.Cached;
import org.talend.sdk.component.api.service.cache.LocalCache;
import org.talend.sdk.component.api.service.interceptor.InterceptorHandler;
import org.talend.sdk.component.api.service.interceptor.Intercepts;
import org.talend.sdk.component.runtime.manager.interceptor.CacheHandler;

public class InterceptorHandlerFacade
implements InterceptorHandler {
    private final Object delegate;
    private final Map<Class<?>, Object> services;
    private final ConcurrentMap<Method, BiFunction<Method, Object[], Object>> invocations = new ConcurrentHashMap<Method, BiFunction<Method, Object[], Object>>();

    @Override
    public Object invoke(Method method, Object[] args) {
        return this.invocations.computeIfAbsent(method, m -> {
            Collection handlers = Stream.of(method.getAnnotations()).filter(a -> this.interceptsConfig((Annotation)a) != null).sorted(Comparator.comparing(a -> this.interceptsConfig((Annotation)a).priority())).map(a -> Optional.of(this.interceptsConfig((Annotation)a).value()).filter(v -> v != InterceptorHandler.class).map(handler -> {
                Optional<Constructor<?>> constructor = this.findConstructor((Class<? extends InterceptorHandler>)handler, BiFunction.class);
                if (constructor.isPresent()) {
                    return new InvokerHandler(constructor.get(), true, null);
                }
                constructor = this.findConstructor((Class<? extends InterceptorHandler>)handler, Object.class);
                if (constructor.isPresent()) {
                    return new InvokerHandler(constructor.get(), false, null);
                }
                constructor = this.findConstructor((Class<? extends InterceptorHandler>)handler, null);
                if (constructor.isPresent()) {
                    return new InvokerHandler(constructor.get(), false, null);
                }
                throw new IllegalArgumentException("No available constructor for " + handler);
            }).map(InvokerHandler.class::cast).orElseGet(() -> {
                if (a.annotationType() == Cached.class) {
                    try {
                        return new InvokerHandler(CacheHandler.class.getConstructor(BiFunction.class, LocalCache.class), true, null);
                    }
                    catch (NoSuchMethodException e) {
                        throw new IllegalStateException("Bad classpath", e);
                    }
                }
                throw new IllegalArgumentException("No handler for " + a);
            })).collect(Collectors.toList());
            if (handlers.isEmpty()) {
                return (mtd, arguments) -> this.doInvoke(method, args);
            }
            List invokerHandlers = handlers.stream().filter(i -> ((InvokerHandler)i).invoker).map(InvokerHandler.class::cast).collect(Collectors.toList());
            if (invokerHandlers.isEmpty() && handlers.size() > 1) {
                throw new IllegalArgumentException("Interceptors not compatible for " + m + ": " + handlers.stream().filter(i -> !invokerHandlers.contains(i)).collect(Collectors.toList()));
            }
            if (invokerHandlers.isEmpty()) {
                return ((InvokerHandler)handlers.iterator().next())::invoke;
            }
            if (invokerHandlers.size() != handlers.size()) {
                throw new IllegalArgumentException("Some handlers don't take an invoker as parameter for method " + m + ": " + handlers.stream().filter(i -> !invokerHandlers.contains(i)).collect(Collectors.toList()));
            }
            for (int i2 = 0; i2 < invokerHandlers.size(); ++i2) {
                InvokerHandler invokerHandler = (InvokerHandler)invokerHandlers.get(i2);
                invokerHandler.init(i2 == invokerHandlers.size() - 1 ? this::doInvoke : ((InvokerHandler)invokerHandlers.get(i2 + 1))::invoke, this.delegate, this.services);
            }
            return ((InvokerHandler)invokerHandlers.get(0))::invoke;
        }).apply(method, args);
    }

    private Intercepts interceptsConfig(Annotation a) {
        return a.annotationType().getAnnotation(Intercepts.class);
    }

    private Optional<Constructor<?>> findConstructor(Class<? extends InterceptorHandler> handler, Class<?> firstParamType) {
        return Stream.of(handler.getConstructors()).filter(c -> firstParamType == null || c.getParameterCount() > 0 && c.getParameterTypes()[0] == firstParamType).findFirst();
    }

    private Object doInvoke(Method method, Object[] args) {
        try {
            return method.invoke(this.delegate, args);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (RuntimeException.class.isInstance(cause)) {
                throw (RuntimeException)RuntimeException.class.cast(cause);
            }
            throw new IllegalStateException(cause.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public InterceptorHandlerFacade(Object delegate, Map<Class<?>, Object> services) {
        this.delegate = delegate;
        this.services = services;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public static class InvokerHandler
    implements InterceptorHandler {
        private final Constructor<?> constructor;
        private final boolean invoker;
        private InterceptorHandler delegate;

        @Override
        public Object invoke(Method method, Object[] args) {
            return this.delegate.invoke(method, args);
        }

        private void init(BiFunction<Method, Object[], Object> invoker, Object delegate, Map<Class<?>, Object> services) {
            try {
                Object[] args = this.buildArgs(invoker, delegate, services);
                this.delegate = (InterceptorHandler)InterceptorHandler.class.cast(this.constructor.newInstance(args));
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e.getCause());
            }
        }

        private Object[] buildArgs(BiFunction<Method, Object[], Object> invoker, Object delegate, Map<Class<?>, Object> services) {
            Object[] args = new Object[this.constructor.getParameterCount()];
            for (int i = 0; i < this.constructor.getParameterCount(); ++i) {
                Class<?> type = this.constructor.getParameterTypes()[i];
                args[i] = BiFunction.class == type ? invoker : (Object.class == type ? delegate : services.get(type));
            }
            return args;
        }

        public InvokerHandler(Constructor<?> constructor, boolean invoker, InterceptorHandler delegate) {
            this.constructor = constructor;
            this.invoker = invoker;
            this.delegate = delegate;
        }
    }
}

