/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.reflect.parameterenricher;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.talend.sdk.component.api.configuration.action.meta.ActionRef;
import org.talend.sdk.component.api.service.ActionType;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.BaseParameterEnricher;

public class ActionParameterEnricher
extends BaseParameterEnricher {
    public static final String META_PREFIX = "tcomp::action::";
    private final ConcurrentMap<String, String> clientActionsMapping = new ConcurrentHashMap<String, String>();

    @Override
    public Map<String, String> onParameterAnnotation(String parameterName, Type parameterType, final Annotation annotation) {
        final Class<? extends Annotation> annotationType = annotation.annotationType();
        final ActionRef ref = annotationType.getAnnotation(ActionRef.class);
        if (ref == null) {
            return Collections.emptyMap();
        }
        Class<?> actionType = ref.value();
        if (actionType == Object.class) {
            return Collections.singletonMap(META_PREFIX + this.clientActionsMapping.computeIfAbsent(annotationType.getSimpleName(), this::toSnakeCase), this.getClientActionName(annotation));
        }
        final String type = actionType.getAnnotation(ActionType.class).value();
        return new HashMap<String, String>(){
            {
                this.put(ActionParameterEnricher.META_PREFIX + type, ActionParameterEnricher.this.getValueString(ref.ref(), annotation));
                Optional.ofNullable(ActionParameterEnricher.this.getParametersString(annotation)).ifPresent(v -> this.put(ActionParameterEnricher.META_PREFIX + type + "::parameters", v));
                Stream.of(annotationType.getMethods()).filter(it -> annotationType == it.getDeclaringClass() && Stream.of("parameters", "value").noneMatch(v -> it.getName().equalsIgnoreCase((String)v))).forEach((? super T m) -> this.put(ActionParameterEnricher.META_PREFIX + type + "::" + m.getName(), ActionParameterEnricher.this.getString(m, annotation)));
            }
        };
    }

    private String toSnakeCase(String camelCaseName) {
        char[] chars = camelCaseName.substring(1).toCharArray();
        return Character.toLowerCase(camelCaseName.charAt(0)) + IntStream.range(0, chars.length).mapToObj(i -> Character.valueOf(chars[i])).map(c -> {
            if (Character.isUpperCase(c.charValue())) {
                return "_" + Character.toLowerCase(c.charValue());
            }
            return Character.toString(c.charValue());
        }).collect(Collectors.joining());
    }

    private String getClientActionName(Annotation clientMeta) {
        String value = this.getValueString("value", clientMeta);
        return "CUSTOM".equalsIgnoreCase(value) ? this.getValueString("name", clientMeta) : value;
    }

    private String getString(Method method, Annotation annotation) {
        try {
            return String.valueOf(method.invoke((Object)annotation, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("No valid " + method + " for " + annotation);
        }
    }

    private String getValueString(String method, Annotation annotation) {
        try {
            return this.getString(annotation.annotationType().getMethod(method, new Class[0]), annotation);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No " + method + " for " + annotation);
        }
    }

    private String getParametersString(Annotation annotation) {
        try {
            return String.join((CharSequence)",", (CharSequence[])String[].class.cast(annotation.annotationType().getMethod("parameters", new Class[0]).invoke((Object)annotation, new Object[0])));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }
}

