/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.reflect.parameterenricher;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.configuration.dependency.ConnectorRef;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.BaseParameterEnricher;

public class DependencyParameterEnricher
extends BaseParameterEnricher {
    private static final Logger log = LoggerFactory.getLogger(DependencyParameterEnricher.class);
    public static final String TCOMP_DEPENDENCIES_CONNECTOR_KEY = "tcomp::dependencies::connector";

    @Override
    public Map<String, String> onParameterAnnotation(String parameterName, Type parameterType, Annotation annotation) {
        if (this.isConnectorReference(parameterType) || this.isCollectionConnectorReference(parameterType)) {
            return Collections.singletonMap(TCOMP_DEPENDENCIES_CONNECTOR_KEY, "family");
        }
        if (String.class.equals((Object)parameterType) && annotation != null && ConnectorRef.class.equals(annotation.annotationType())) {
            return Collections.singletonMap(TCOMP_DEPENDENCIES_CONNECTOR_KEY, ((ConnectorRef)annotation).value().getRefValue());
        }
        return Collections.emptyMap();
    }

    private boolean isCollectionConnectorReference(Type parameterType) {
        if (!(parameterType instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterClass = (ParameterizedType)parameterType;
        Type rawType = parameterClass.getRawType();
        if (!(rawType instanceof Class) || !Collection.class.isAssignableFrom((Class)rawType)) {
            return false;
        }
        Type[] arguments = parameterClass.getActualTypeArguments();
        if (arguments.length != 1) {
            return false;
        }
        Type argument = arguments[0];
        return this.isConnectorReference(argument);
    }

    private boolean isConnectorReference(Type parameterType) {
        return parameterType instanceof Class && Stream.of(((Class)parameterType).getDeclaredFields()).anyMatch(field -> field.isAnnotationPresent(ConnectorRef.class));
    }
}

