/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.reflect.visibility;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonPointer;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import org.talend.sdk.component.runtime.manager.ParameterMeta;

public class VisibilityService {
    private final AbsolutePathResolver pathResolver = new AbsolutePathResolver();
    private final JsonProvider jsonProvider;

    public ConditionGroup build(ParameterMeta param) {
        boolean and = "AND".equalsIgnoreCase(param.getMetadata().getOrDefault("tcomp::condition::ifs::operator", "AND"));
        return new ConditionGroup(param.getMetadata().entrySet().stream().filter(meta -> ((String)meta.getKey()).startsWith("tcomp::condition::if::target")).map(meta -> {
            String[] split = ((String)meta.getKey()).split("::");
            String index = split.length == 5 ? "::" + split[split.length - 1] : "";
            String valueKey = "tcomp::condition::if::value" + index;
            String negateKey = "tcomp::condition::if::negate" + index;
            String evaluationStrategyKey = "tcomp::condition::if::evaluationStrategy" + index;
            String absoluteTargetPath = this.pathResolver.resolveProperty(param.getPath(), (String)meta.getValue());
            return new Condition(this.toPointer(absoluteTargetPath), Boolean.parseBoolean(param.getMetadata().getOrDefault(negateKey, "false")), param.getMetadata().getOrDefault(evaluationStrategyKey, "DEFAULT").toUpperCase(Locale.ROOT), param.getMetadata().getOrDefault(valueKey, "true").split(","));
        }).collect(Collectors.toList()), and ? stream -> stream.allMatch(i -> i) : stream -> stream.anyMatch(i -> i));
    }

    private JsonPointer toPointer(String absoluteTargetPath) {
        return this.jsonProvider.createPointer('/' + absoluteTargetPath.replace('.', '/'));
    }

    public VisibilityService(JsonProvider jsonProvider) {
        this.jsonProvider = jsonProvider;
    }

    public static class ConditionGroup {
        private final Collection<Condition> conditions;
        private final Function<Stream<Boolean>, Boolean> aggregator;

        public boolean isVisible(JsonObject payload) {
            return this.conditions.stream().allMatch(group -> this.aggregator.apply(this.conditions.stream().map(c -> c.evaluateCondition(payload))));
        }

        private ConditionGroup(Collection<Condition> conditions, Function<Stream<Boolean>, Boolean> aggregator) {
            this.conditions = conditions;
            this.aggregator = aggregator;
        }
    }

    private static class AbsolutePathResolver {
        private String resolveProperty(String propPath, String paramRef) {
            return this.doResolveProperty(propPath, this.normalizeParamRef(paramRef));
        }

        private String normalizeParamRef(String paramRef) {
            return (!paramRef.contains(".") ? "../" : "") + paramRef;
        }

        private String doResolveProperty(String propPath, String paramRef) {
            if (".".equals(paramRef)) {
                return propPath;
            }
            if (paramRef.startsWith("..")) {
                String current = propPath;
                String ref = paramRef;
                while (ref.startsWith("..")) {
                    int lastDot = current.lastIndexOf(46);
                    if (lastDot < 0) {
                        lastDot = 0;
                    }
                    current = current.substring(0, lastDot);
                    if ((ref = ref.substring("..".length(), ref.length())).startsWith("/")) {
                        ref = ref.substring(1);
                    }
                    if (!current.isEmpty()) continue;
                    break;
                }
                return Stream.of(current, ref.replace('/', '.')).filter(it -> !it.isEmpty()).collect(Collectors.joining("."));
            }
            if (paramRef.startsWith(".") || paramRef.startsWith("./")) {
                return propPath + '.' + paramRef.replaceFirst("\\./?", "").replace('/', '.');
            }
            return paramRef;
        }

        private AbsolutePathResolver() {
        }
    }

    public static class Condition {
        private static final Function<Object, String> TO_STRING = v -> v == null ? null : String.valueOf(v);
        private static final Function<Object, String> TO_LOWERCASE = v -> v == null ? null : String.valueOf(v).toLowerCase(Locale.ROOT);
        private final JsonPointer pointer;
        private final boolean negation;
        private final String evaluationStrategy;
        private final String[] values;

        boolean evaluateCondition(JsonObject payload) {
            return this.negation != Stream.of(this.values).anyMatch(val -> this.evaluate((String)val, payload));
        }

        private boolean evaluate(String expected, JsonObject payload) {
            Object actual = this.extractValue(payload);
            switch (this.evaluationStrategy) {
                case "DEFAULT": {
                    return expected.equals(TO_STRING.apply(actual));
                }
                case "LENGTH": {
                    if (actual == null) {
                        return "0".equals(expected);
                    }
                    int expectedSize = Integer.parseInt(expected);
                    if (Collection.class.isInstance(actual)) {
                        return expectedSize == ((Collection)Collection.class.cast(actual)).size();
                    }
                    if (actual.getClass().isArray()) {
                        return expectedSize == Array.getLength(actual);
                    }
                    if (String.class.isInstance(actual)) {
                        return expectedSize == ((String)String.class.cast(actual)).length();
                    }
                    return false;
                }
            }
            Function<Object, String> preprocessor = TO_STRING;
            if (this.evaluationStrategy.startsWith("CONTAINS")) {
                Map<String, String> configuration;
                int end;
                int start = this.evaluationStrategy.indexOf(40);
                if (start >= 0 && (end = this.evaluationStrategy.indexOf(41, start)) >= 0 && Boolean.parseBoolean((configuration = Stream.of(this.evaluationStrategy.substring(start + 1, end).split(",")).map(String::trim).filter(it -> !it.isEmpty()).map(it -> {
                    int sep = it.indexOf(61);
                    if (sep > 0) {
                        return new String[]{it.substring(0, sep), it.substring(sep + 1)};
                    }
                    return new String[]{"value", it};
                }).collect(Collectors.toMap(a -> a[0], a -> a[1]))).getOrDefault("lowercase", "false"))) {
                    preprocessor = TO_LOWERCASE;
                }
                if (actual == null) {
                    return false;
                }
                if (CharSequence.class.isInstance(actual)) {
                    return Optional.ofNullable(preprocessor.apply(TO_STRING.apply(actual))).map(it -> it.contains(expected)).orElse(false);
                }
                if (Collection.class.isInstance(actual)) {
                    Collection collection = (Collection)Collection.class.cast(actual);
                    return collection.stream().map(preprocessor).anyMatch(it -> it.contains(expected));
                }
                if (actual.getClass().isArray()) {
                    return IntStream.range(0, Array.getLength(actual)).mapToObj(i -> Array.get(actual, i)).map(preprocessor).anyMatch(it -> it.contains(expected));
                }
                return false;
            }
            throw new IllegalArgumentException("Not supported operation '" + this.evaluationStrategy + "'");
        }

        private Object extractValue(JsonObject payload) {
            if (!this.pointer.containsValue(payload)) {
                return null;
            }
            return Optional.ofNullable(this.pointer.getValue(payload)).map(this::mapValue).orElse(null);
        }

        private Object mapValue(JsonValue value) {
            switch (value.getValueType()) {
                case ARRAY: {
                    return value.asJsonArray().stream().map(this::mapValue).collect(Collectors.toList());
                }
                case STRING: {
                    return ((JsonString)JsonString.class.cast(value)).getString();
                }
                case TRUE: {
                    return true;
                }
                case FALSE: {
                    return false;
                }
                case NUMBER: {
                    return ((JsonNumber)JsonNumber.class.cast(value)).doubleValue();
                }
                case NULL: {
                    return null;
                }
            }
            return value;
        }

        private Condition(JsonPointer pointer, boolean negation, String evaluationStrategy, String[] values) {
            this.pointer = pointer;
            this.negation = negation;
            this.evaluationStrategy = evaluationStrategy;
            this.values = values;
        }
    }
}

