/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.json.JsonBuilderFactory;
import javax.json.JsonReaderFactory;
import javax.json.JsonWriterFactory;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.spi.JsonbProvider;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParserFactory;
import org.apache.johnzon.mapper.MapperBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.record.RecordPointerFactory;
import org.talend.sdk.component.api.service.cache.LocalCache;
import org.talend.sdk.component.api.service.configuration.LocalConfiguration;
import org.talend.sdk.component.api.service.dependency.Resolver;
import org.talend.sdk.component.api.service.factory.ObjectFactory;
import org.talend.sdk.component.api.service.http.HttpClientFactory;
import org.talend.sdk.component.api.service.injector.Injector;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.api.service.record.RecordService;
import org.talend.sdk.component.api.service.source.ProducerFinder;
import org.talend.sdk.component.runtime.manager.asm.ProxyGenerator;
import org.talend.sdk.component.runtime.manager.json.PreComputedJsonpProvider;
import org.talend.sdk.component.runtime.manager.proxy.JavaProxyEnricherFactory;
import org.talend.sdk.component.runtime.manager.reflect.ReflectionService;
import org.talend.sdk.component.runtime.manager.service.ContainerInfo;
import org.talend.sdk.component.runtime.manager.service.GenericOrPojoJsonb;
import org.talend.sdk.component.runtime.manager.service.InjectorImpl;
import org.talend.sdk.component.runtime.manager.service.LocalCacheService;
import org.talend.sdk.component.runtime.manager.service.LocalConfigurationService;
import org.talend.sdk.component.runtime.manager.service.ObjectFactoryImpl;
import org.talend.sdk.component.runtime.manager.service.ProducerFinderImpl;
import org.talend.sdk.component.runtime.manager.service.RecordPointerFactoryImpl;
import org.talend.sdk.component.runtime.manager.service.RecordServiceImpl;
import org.talend.sdk.component.runtime.manager.service.ResolverImpl;
import org.talend.sdk.component.runtime.manager.service.api.ComponentInstantiator;
import org.talend.sdk.component.runtime.manager.service.configuration.PropertiesConfiguration;
import org.talend.sdk.component.runtime.manager.service.http.HttpClientFactoryImpl;
import org.talend.sdk.component.runtime.manager.util.Lazy;
import org.talend.sdk.component.runtime.manager.util.MemoizingSupplier;
import org.talend.sdk.component.runtime.manager.xbean.registry.EnrichedPropertyEditorRegistry;
import org.talend.sdk.component.runtime.record.json.RecordJsonGenerator;

public class DefaultServiceProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultServiceProvider.class);
    private final ReflectionService reflections;
    private final JsonProvider jsonpProvider;
    private final JsonGeneratorFactory jsonpGeneratorFactory;
    private final JsonReaderFactory jsonpReaderFactory;
    private final JsonBuilderFactory jsonpBuilderFactory;
    private final JsonParserFactory jsonpParserFactory;
    private final JsonWriterFactory jsonpWriterFactory;
    private final JsonbConfig jsonbConfig;
    private final JsonbProvider jsonbProvider;
    private final ProxyGenerator proxyGenerator;
    private final JavaProxyEnricherFactory javaProxyEnricherFactory;
    private final Collection<LocalConfiguration> localConfigurations;
    private final Function<String, RecordBuilderFactory> recordBuilderFactoryProvider;
    private final EnrichedPropertyEditorRegistry propertyEditorRegistry;
    private final Supplier<ScheduledExecutorService> executorService = new MemoizingSupplier<ScheduledExecutorService>(this::buildExecutorService);

    public <T> T lookup(String id, ClassLoader loader, Supplier<List<InputStream>> localConfigLookup, Function<String, Path> resolver, Class<T> api, AtomicReference<Map<Class<?>, Object>> services, ComponentInstantiator.Builder instantiators) {
        return api.cast(this.doLookup(id, loader, localConfigLookup, resolver, api, services, instantiators));
    }

    private Object doLookup(String id, ClassLoader loader, Supplier<List<InputStream>> localConfigLookup, Function<String, Path> resolver, Class<?> api, AtomicReference<Map<Class<?>, Object>> services, ComponentInstantiator.Builder instantiators) {
        if (JsonProvider.class == api) {
            return new PreComputedJsonpProvider(id, this.jsonpProvider, this.jsonpParserFactory, this.jsonpWriterFactory, this.jsonpBuilderFactory, this.jsonpGeneratorFactory, this.jsonpReaderFactory);
        }
        if (JsonBuilderFactory.class == api) {
            return this.javaProxyEnricherFactory.asSerializable(loader, id, JsonBuilderFactory.class.getName(), this.jsonpBuilderFactory);
        }
        if (JsonParserFactory.class == api) {
            return this.javaProxyEnricherFactory.asSerializable(loader, id, JsonParserFactory.class.getName(), this.jsonpParserFactory);
        }
        if (JsonReaderFactory.class == api) {
            return this.javaProxyEnricherFactory.asSerializable(loader, id, JsonReaderFactory.class.getName(), this.jsonpReaderFactory);
        }
        if (JsonWriterFactory.class == api) {
            return this.javaProxyEnricherFactory.asSerializable(loader, id, JsonWriterFactory.class.getName(), this.jsonpWriterFactory);
        }
        if (JsonGeneratorFactory.class == api) {
            return this.javaProxyEnricherFactory.asSerializable(loader, id, JsonGeneratorFactory.class.getName(), this.jsonpGeneratorFactory);
        }
        if (Jsonb.class == api) {
            JsonbBuilder jsonbBuilder = this.createPojoJsonbBuilder(id, Lazy.lazy(() -> (Jsonb)Jsonb.class.cast(this.doLookup(id, loader, localConfigLookup, resolver, Jsonb.class, services, instantiators))));
            return new GenericOrPojoJsonb(id, this.jsonbProvider.create().withProvider(this.jsonpProvider).withConfig(this.jsonbConfig).build(), jsonbBuilder.build());
        }
        if (LocalConfiguration.class == api) {
            Stream<InputStream> localConfigs;
            Properties aggregatedLocalConfigs;
            ArrayList<LocalConfiguration> containerConfigurations = new ArrayList<LocalConfiguration>(this.localConfigurations);
            if (!Boolean.getBoolean("talend.component.configuration." + id + ".ignoreLocalConfiguration") && !(aggregatedLocalConfigs = this.aggregateConfigurations(localConfigs = localConfigLookup.get().stream())).isEmpty()) {
                containerConfigurations.add(new PropertiesConfiguration(aggregatedLocalConfigs));
            }
            return new LocalConfigurationService(containerConfigurations, id);
        }
        if (RecordBuilderFactory.class == api) {
            return this.recordBuilderFactoryProvider.apply(id);
        }
        if (ProxyGenerator.class == api) {
            return this.proxyGenerator;
        }
        if (LocalCache.class == api) {
            LocalCacheService service = new LocalCacheService(id, System::currentTimeMillis, this.executorService);
            ((Injector)Injector.class.cast(services.get().get(Injector.class))).inject(service);
            return service;
        }
        if (Injector.class == api) {
            return new InjectorImpl(id, this.reflections, this.proxyGenerator, services.get());
        }
        if (HttpClientFactory.class == api) {
            return new HttpClientFactoryImpl(id, this.reflections, (Jsonb)Jsonb.class.cast(services.get().get(Jsonb.class)), services.get());
        }
        if (Resolver.class == api) {
            return new ResolverImpl(id, resolver);
        }
        if (ObjectFactory.class == api) {
            return new ObjectFactoryImpl(id, this.propertyEditorRegistry);
        }
        if (ProducerFinder.class == api) {
            RecordService recordService = this.lookup(id, loader, localConfigLookup, resolver, RecordService.class, services, instantiators);
            Iterator<ProducerFinder> producerFinders = ServiceLoader.load(ProducerFinder.class, loader).iterator();
            if (producerFinders.hasNext()) {
                ProducerFinder producerFinder = producerFinders.next();
                if (producerFinders.hasNext()) {
                    log.warn("More than one ProducerFinder are available via SPI, using {}.", (Object)producerFinder.getClass().getSimpleName());
                }
                return producerFinder.init(id, instantiators, recordService::toRecord);
            }
            return new ProducerFinderImpl().init(id, instantiators, recordService::toRecord);
        }
        if (RecordPointerFactory.class == api) {
            return new RecordPointerFactoryImpl(id);
        }
        if (ContainerInfo.class == api) {
            return new ContainerInfo(id);
        }
        if (RecordService.class == api) {
            return new RecordServiceImpl(id, this.recordBuilderFactoryProvider.apply(id), () -> this.jsonpBuilderFactory, () -> this.jsonpProvider, Lazy.lazy(() -> (Jsonb)Jsonb.class.cast(this.doLookup(id, loader, localConfigLookup, resolver, Jsonb.class, services, instantiators))));
        }
        return null;
    }

    private JsonbBuilder createPojoJsonbBuilder(String id, Supplier<Jsonb> jsonb) {
        JsonbBuilder jsonbBuilder = JsonbBuilder.newBuilder().withProvider(new PreComputedJsonpProvider(id, this.jsonpProvider, this.jsonpParserFactory, this.jsonpWriterFactory, this.jsonpBuilderFactory, new RecordJsonGenerator.Factory(Lazy.lazy(() -> this.recordBuilderFactoryProvider.apply(id)), jsonb, Collections.emptyMap()), this.jsonpReaderFactory)).withConfig(this.jsonbConfig);
        try {
            Field mapper = jsonbBuilder.getClass().getDeclaredField("builder");
            if (!mapper.isAccessible()) {
                mapper.setAccessible(true);
            }
            ((MapperBuilder)MapperBuilder.class.cast(mapper.get(jsonbBuilder))).setDoCloseOnStreams(true);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return jsonbBuilder;
    }

    private Properties aggregateConfigurations(Stream<InputStream> localConfigs) {
        AtomicReference re = new AtomicReference();
        Properties result = localConfigs.map(stream -> {
            Properties properties = new Properties();
            try {
                if (stream != null) {
                    properties.load((InputStream)stream);
                }
                Properties properties2 = properties;
                return properties2;
            }
            catch (IOException e) {
                log.error(e.getMessage(), e);
                RuntimeException runtimeException = (RuntimeException)re.get();
                if (runtimeException == null) {
                    runtimeException = new IllegalStateException("Can't read all local configurations");
                    re.set(runtimeException);
                }
                runtimeException.addSuppressed(e);
                Properties properties3 = properties;
                return properties3;
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }).sorted(Comparator.comparing(it -> Integer.parseInt(it.getProperty("_ordinal", "0")))).reduce(new Properties(), (p1, p2) -> {
            p1.putAll((Map<?, ?>)p2);
            return p1;
        });
        RuntimeException error = (RuntimeException)re.get();
        if (error != null) {
            throw error;
        }
        return result;
    }

    private ScheduledExecutorService buildExecutorService() {
        return Executors.newScheduledThreadPool(4, r -> {
            Thread thread = new Thread(r, DefaultServiceProvider.class.getName() + "-services-" + this.hashCode());
            thread.setPriority(5);
            return thread;
        });
    }

    public DefaultServiceProvider(ReflectionService reflections, JsonProvider jsonpProvider, JsonGeneratorFactory jsonpGeneratorFactory, JsonReaderFactory jsonpReaderFactory, JsonBuilderFactory jsonpBuilderFactory, JsonParserFactory jsonpParserFactory, JsonWriterFactory jsonpWriterFactory, JsonbConfig jsonbConfig, JsonbProvider jsonbProvider, ProxyGenerator proxyGenerator, JavaProxyEnricherFactory javaProxyEnricherFactory, Collection<LocalConfiguration> localConfigurations, Function<String, RecordBuilderFactory> recordBuilderFactoryProvider, EnrichedPropertyEditorRegistry propertyEditorRegistry) {
        this.reflections = reflections;
        this.jsonpProvider = jsonpProvider;
        this.jsonpGeneratorFactory = jsonpGeneratorFactory;
        this.jsonpReaderFactory = jsonpReaderFactory;
        this.jsonpBuilderFactory = jsonpBuilderFactory;
        this.jsonpParserFactory = jsonpParserFactory;
        this.jsonpWriterFactory = jsonpWriterFactory;
        this.jsonbConfig = jsonbConfig;
        this.jsonbProvider = jsonbProvider;
        this.proxyGenerator = proxyGenerator;
        this.javaProxyEnricherFactory = javaProxyEnricherFactory;
        this.localConfigurations = localConfigurations;
        this.recordBuilderFactoryProvider = recordBuilderFactoryProvider;
        this.propertyEditorRegistry = propertyEditorRegistry;
    }
}

