/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.talend.sdk.component.api.service.Service;
import org.talend.sdk.component.api.service.configuration.Configuration;
import org.talend.sdk.component.api.service.injector.Injector;
import org.talend.sdk.component.runtime.manager.asm.ProxyGenerator;
import org.talend.sdk.component.runtime.manager.reflect.ReflectionService;
import org.talend.sdk.component.runtime.serialization.SerializableService;

public class InjectorImpl
implements Serializable,
Injector {
    private final String plugin;
    private final ReflectionService reflectionService;
    private final ProxyGenerator proxyGenerator;
    private final Map<Class<?>, Object> services;

    @Override
    public <T> T inject(T instance) {
        if (instance == null) {
            return null;
        }
        this.doInject(instance.getClass(), this.unwrap(instance));
        return instance;
    }

    private Object unwrap(Object instance) {
        if (instance.getClass().getName().endsWith("$$TalendServiceProxy")) {
            try {
                return this.proxyGenerator.getHandler(instance).getDelegate();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return instance;
    }

    private <T> void doInject(Class<?> type, T instance) {
        if (type == Object.class || type == null) {
            return;
        }
        Field[] fields = type.getDeclaredFields();
        Stream.of(fields).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> field.isAnnotationPresent(Service.class)).peek(f -> {
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
        }).forEach(field -> {
            Type serviceType;
            ParameterizedType pt;
            List value = this.services.get(field.getType());
            if (value == null && ParameterizedType.class.isInstance(field.getGenericType()) && Class.class.isInstance((pt = (ParameterizedType)ParameterizedType.class.cast(field.getGenericType())).getRawType()) && Collection.class.isAssignableFrom((Class)Class.class.cast(pt.getRawType())) && Class.class.isInstance(serviceType = pt.getActualTypeArguments()[0])) {
                Class serviceClass = (Class)Class.class.cast(serviceType);
                value = this.services.entrySet().stream().filter(e -> serviceClass.isAssignableFrom((Class)e.getKey())).collect(Collectors.toList());
            }
            if (value != null) {
                try {
                    field.set(instance, value);
                }
                catch (IllegalAccessException e2) {
                    throw new IllegalArgumentException(e2);
                }
            }
        });
        Stream.of(fields).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> field.isAnnotationPresent(Configuration.class)).peek(field -> {
            if (Supplier.class != field.getType() || !ParameterizedType.class.isInstance(field.getGenericType())) {
                throw new IllegalArgumentException("Field " + field + " is not a Supplier<X>,\nit will not be injected otherwise it wouldn't be up to date,\ndid you mean Supplier<" + field.getType() + "> ?");
            }
        }).peek(f -> {
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
        }).forEach(field -> {
            try {
                Class configClass = (Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(field.getGenericType())).getActualTypeArguments()[0]);
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Supplier<Object> supplier = () -> {
                    try {
                        return this.reflectionService.createConfigFactory(this.services, loader, this.reflectionService.createContextualSupplier(loader), field.getName(), field.getAnnotation(Configuration.class), field.getAnnotations(), configClass).apply(Collections.emptyMap());
                    }
                    catch (NoSuchMethodException e) {
                        throw new IllegalStateException(e);
                    }
                };
                field.set(instance, supplier);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        });
        if (type.getSuperclass() != type) {
            this.doInject(type.getSuperclass(), instance);
        }
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializableService(this.plugin, Injector.class.getName());
    }

    public InjectorImpl(String plugin, ReflectionService reflectionService, ProxyGenerator proxyGenerator, Map<Class<?>, Object> services) {
        this.plugin = plugin;
        this.reflectionService = reflectionService;
        this.proxyGenerator = proxyGenerator;
        this.services = services;
    }
}

