/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.service.cache.LocalCache;
import org.talend.sdk.component.api.service.configuration.Configuration;
import org.talend.sdk.component.runtime.serialization.SerializableService;

public class LocalCacheService
implements LocalCache,
Serializable {
    private final String plugin;
    private final Supplier<Long> timer;
    private final ConcurrentMap<String, ElementImpl> cache = new ConcurrentHashMap<String, ElementImpl>();
    @Configuration(value="talend.component.manager.services.cache.eviction")
    private Supplier<CacheConfiguration> configuration;
    private transient Supplier<ScheduledExecutorService> threadServiceGetter;

    public LocalCacheService(String plugin, Supplier<Long> timer, Supplier<ScheduledExecutorService> threadServiceGetter) {
        this.plugin = plugin;
        this.timer = timer;
        this.threadServiceGetter = threadServiceGetter;
    }

    @Override
    public void evict(String key) {
        String realKey = this.internalKey(key);
        this.cache.compute(realKey, (oldKey, oldElement) -> {
            if (oldElement != null && oldElement.canBeEvict()) {
                oldElement.release();
                return null;
            }
            return oldElement;
        });
    }

    @Override
    public void evictIfValue(String key, Object expected) {
        String realKey = this.internalKey(key);
        this.cache.compute(realKey, (oldKey, oldElement) -> {
            if (oldElement != null && (Objects.equals(oldElement.getValue(), expected) || oldElement.canBeEvict())) {
                oldElement.release();
                return null;
            }
            return oldElement;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T computeIfAbsent(Class<T> expectedClass, String key, Predicate<LocalCache.Element> toRemove, long timeoutMs, Supplier<T> value) {
        Integer maxSize = this.getConfigValue(CacheConfiguration::getDefaultMaxSize, -1);
        if (maxSize > 0 && this.cache.size() >= maxSize) {
            this.clean();
            if (this.cache.size() >= maxSize) {
                ConcurrentMap<String, ElementImpl> concurrentMap = this.cache;
                synchronized (concurrentMap) {
                    while (this.cache.size() >= maxSize) {
                        String keyToRemove = (String)this.cache.keySet().iterator().next();
                        this.cache.remove(keyToRemove);
                    }
                }
            }
        }
        ScheduledFuture<?> task = timeoutMs > 0L ? this.evictionTask(key, timeoutMs) : null;
        long endOfValidity = this.calcEndOfValidity(timeoutMs);
        ElementImpl element = this.addToMap(key, () -> new ElementImpl(value, toRemove, endOfValidity, task, this.timer));
        return element.getValue(expectedClass);
    }

    @Override
    public <T> T computeIfAbsent(Class<T> expectedClass, String key, Predicate<LocalCache.Element> toRemove, Supplier<T> value) {
        long timeout = this.getConfigValue(CacheConfiguration::getDefaultEvictionTimeout, -1L);
        return this.computeIfAbsent(expectedClass, key, toRemove, timeout, value);
    }

    @Override
    public <T> T computeIfAbsent(Class<T> expectedClass, String key, long timeoutMs, Supplier<T> value) {
        return this.computeIfAbsent(expectedClass, key, null, timeoutMs, value);
    }

    private ElementImpl addToMap(String key, Supplier<ElementImpl> builder) {
        String internalKey = this.internalKey(key);
        return this.cache.compute(internalKey, (k, old) -> old == null || old.mustBeRemoved() ? (ElementImpl)builder.get() : old);
    }

    @Override
    public <T> T computeIfAbsent(Class<T> expectedClass, String key, Supplier<T> value) {
        long timeOut = this.getConfigValue(CacheConfiguration::getDefaultEvictionTimeout, -1L);
        return this.computeIfAbsent(expectedClass, key, null, timeOut, value);
    }

    @PreDestroy
    public void release() {
        this.cache.forEach((k, e) -> e.release());
        this.cache.clear();
    }

    private long calcEndOfValidity(long timeoutMs) {
        return timeoutMs > 0L ? this.timer.get() + timeoutMs : -1L;
    }

    private String internalKey(String key) {
        return this.plugin + '@' + key;
    }

    public void clean() {
        Stream<Map.Entry> elements = this.cache.entrySet().stream().filter(e -> ((ElementImpl)e.getValue()).mustBeRemoved());
        int maxEviction = this.getConfigValue(CacheConfiguration::getMaxDeletionPerEvictionRun, -1);
        if (maxEviction > 0) {
            elements = elements.limit(maxEviction);
        }
        List<String> removableElements = elements.map(Map.Entry::getKey).collect(Collectors.toList());
        removableElements.forEach(this.cache::remove);
    }

    private ScheduledExecutorService getThreadService() {
        return this.threadServiceGetter.get();
    }

    private ScheduledFuture<?> evictionTask(String key, long delayMillis) {
        return this.getThreadService().schedule(() -> this.evict(key), delayMillis, TimeUnit.MILLISECONDS);
    }

    private <T> T getConfigValue(Function<CacheConfiguration, T> getter, T defaultValue) {
        return Optional.ofNullable(this.getConfig()).map(getter).orElse(defaultValue);
    }

    private CacheConfiguration getConfig() {
        return this.configuration != null ? this.configuration.get() : null;
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializableService(this.plugin, LocalCache.class.getName());
    }

    private static class ElementImpl
    implements LocalCache.Element {
        private final Object value;
        private final Predicate<LocalCache.Element> canBeRemoved;
        private final long endOfValidity;
        private final ScheduledFuture<?> removedTask;
        private final Supplier<Long> serviceTimer;

        public <T> ElementImpl(Supplier<T> value, Predicate<LocalCache.Element> canBeRemoved, long endOfValidity, ScheduledFuture<?> removedTask, Supplier<Long> timer) {
            this.value = value.get();
            this.canBeRemoved = canBeRemoved;
            this.endOfValidity = endOfValidity;
            this.removedTask = removedTask;
            this.serviceTimer = timer;
        }

        @Override
        public <T> T getValue(Class<T> expectedType) {
            if (this.value != null && !expectedType.isInstance(this.value)) {
                throw new ClassCastException(this.value.getClass().getName() + " cannot be cast to " + expectedType.getName());
            }
            return expectedType.cast(this.value);
        }

        @Override
        public long getLastValidityTimestamp() {
            return this.endOfValidity;
        }

        public boolean mustBeRemoved() {
            return this.endOfValidity > 0L && this.endOfValidity <= this.serviceTimer.get() && this.canBeEvict();
        }

        public boolean canBeEvict() {
            return this.canBeRemoved == null || this.canBeRemoved.test(this);
        }

        public synchronized void release() {
            if (this.removedTask != null) {
                this.removedTask.cancel(false);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Objects.equals(((ElementImpl)ElementImpl.class.cast((Object)o)).value, this.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    public static class CacheConfiguration
    implements Serializable {
        @Option
        private long defaultEvictionTimeout;
        @Option
        private int maxDeletionPerEvictionRun;
        @Option
        private int defaultMaxSize;

        public long getDefaultEvictionTimeout() {
            return this.defaultEvictionTimeout;
        }

        public int getMaxDeletionPerEvictionRun() {
            return this.maxDeletionPerEvictionRun;
        }

        public int getDefaultMaxSize() {
            return this.defaultMaxSize;
        }

        public void setDefaultEvictionTimeout(long defaultEvictionTimeout) {
            this.defaultEvictionTimeout = defaultEvictionTimeout;
        }

        public void setMaxDeletionPerEvictionRun(int maxDeletionPerEvictionRun) {
            this.maxDeletionPerEvictionRun = maxDeletionPerEvictionRun;
        }

        public void setDefaultMaxSize(int defaultMaxSize) {
            this.defaultMaxSize = defaultMaxSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheConfiguration)) {
                return false;
            }
            CacheConfiguration other = (CacheConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDefaultEvictionTimeout() != other.getDefaultEvictionTimeout()) {
                return false;
            }
            if (this.getMaxDeletionPerEvictionRun() != other.getMaxDeletionPerEvictionRun()) {
                return false;
            }
            return this.getDefaultMaxSize() == other.getDefaultMaxSize();
        }

        protected boolean canEqual(Object other) {
            return other instanceof CacheConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $defaultEvictionTimeout = this.getDefaultEvictionTimeout();
            result = result * 59 + (int)($defaultEvictionTimeout >>> 32 ^ $defaultEvictionTimeout);
            result = result * 59 + this.getMaxDeletionPerEvictionRun();
            result = result * 59 + this.getDefaultMaxSize();
            return result;
        }

        public String toString() {
            return "LocalCacheService.CacheConfiguration(defaultEvictionTimeout=" + this.getDefaultEvictionTimeout() + ", maxDeletionPerEvictionRun=" + this.getMaxDeletionPerEvictionRun() + ", defaultMaxSize=" + this.getDefaultMaxSize() + ")";
        }
    }
}

