/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service;

import java.io.ObjectStreamException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.service.source.ProducerFinder;
import org.talend.sdk.component.runtime.input.Input;
import org.talend.sdk.component.runtime.input.Mapper;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.service.api.ComponentInstantiator;
import org.talend.sdk.component.runtime.serialization.SerializableService;

public class ProducerFinderImpl
implements ProducerFinder {
    private static final Logger log = LoggerFactory.getLogger(ProducerFinderImpl.class);
    protected String plugin;
    protected ComponentInstantiator.Builder mapperFinder;
    protected Function<Object, Record> recordConverter;

    @Override
    public ProducerFinder init(String plugin, Object builder, Function<Object, Record> converter) {
        this.plugin = plugin;
        this.mapperFinder = (ComponentInstantiator.Builder)ComponentInstantiator.Builder.class.cast(builder);
        this.recordConverter = converter;
        return this;
    }

    @Override
    public Iterator<Record> find(String familyName, String inputName, int version, Map<String, String> configuration) {
        ComponentInstantiator instantiator = this.getInstantiator(familyName, inputName);
        Mapper mapper = this.findMapper(instantiator, version, configuration);
        return this.iterator(mapper.create());
    }

    protected ComponentInstantiator getInstantiator(String familyName, String inputName) {
        ComponentInstantiator.ComponentNameFinder datasetFinder = new ComponentInstantiator.ComponentNameFinder(inputName);
        ComponentInstantiator instantiator = this.mapperFinder.build(familyName, datasetFinder, ComponentManager.ComponentType.MAPPER);
        if (instantiator == null) {
            log.error("Can't find {} for family {}.", (Object)inputName, (Object)familyName);
            throw new IllegalArgumentException(String.format("Can't find %s for family %s.", inputName, familyName));
        }
        return instantiator;
    }

    protected Mapper findMapper(ComponentInstantiator instantiator, int version, Map<String, String> configuration) {
        return (Mapper)instantiator.instantiate(configuration, version);
    }

    protected Iterator<Record> iterator(Input input) {
        InputIterator iteratorObject = new InputIterator(input);
        return new IteratorMap<Object, Record>(iteratorObject, this.recordConverter);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializableService(this.plugin, ProducerFinder.class.getName());
    }

    static class InputIterator
    implements Iterator<Object> {
        private final Input input;
        private Object nextObject;
        private boolean init;

        InputIterator(Input input) {
            this.input = input;
        }

        private static Object findNext(Input input) {
            return input.next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Input input = this.input;
            synchronized (input) {
                if (!this.init) {
                    this.init = true;
                    this.input.start();
                    this.nextObject = InputIterator.findNext(this.input);
                }
                if (this.nextObject == null) {
                    this.input.stop();
                }
            }
            return this.nextObject != null;
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object current = this.nextObject;
            this.nextObject = InputIterator.findNext(this.input);
            return current;
        }
    }

    static class IteratorMap<T, U>
    implements Iterator<U> {
        private final Iterator<T> wrappedIterator;
        private final Function<T, U> converter;

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public U next() {
            T next = this.wrappedIterator.next();
            return this.converter.apply(next);
        }

        public IteratorMap(Iterator<T> wrappedIterator, Function<T, U> converter) {
            this.wrappedIterator = wrappedIterator;
            this.converter = converter;
        }
    }
}

