/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.talend.sdk.component.api.service.dependency.Resolver;
import org.talend.sdk.component.classloader.ConfigurableClassLoader;
import org.talend.sdk.component.dependencies.maven.Artifact;
import org.talend.sdk.component.dependencies.maven.MvnDependencyListLocalRepositoryResolver;
import org.talend.sdk.component.runtime.serialization.SerializableService;

public class ResolverImpl
implements Resolver,
Serializable {
    private final String plugin;
    private final Function<String, Path> fileResolver;

    @Override
    public Resolver.ClassLoaderDescriptor mapDescriptorToClassLoader(InputStream descriptor) {
        ArrayList urls = new ArrayList();
        ArrayList nested = new ArrayList();
        ArrayList<String> resolved = new ArrayList<String>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = Optional.ofNullable(classLoader).map(ClassLoader::getParent).orElseGet(ClassLoader::getSystemClassLoader);
        try {
            String[] stringArray;
            new MvnDependencyListLocalRepositoryResolver(null, this.fileResolver).resolveFromDescriptor(descriptor).forEach(artifact -> {
                String path = artifact.toPath();
                Path file = this.fileResolver.apply(path);
                if (Files.exists(file, new LinkOption[0])) {
                    try {
                        urls.add(file.toUri().toURL());
                        resolved.add(artifact.toCoordinate());
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalStateException(e);
                    }
                } else if (loader.getResource("MAVEN-INF/repository/" + path) != null) {
                    nested.add(path);
                    resolved.add(artifact.toCoordinate());
                }
            });
            String string = this.plugin + "#volatile-resolver";
            Predicate<String> predicate = it -> false;
            Predicate<String> predicate2 = it -> true;
            if (ConfigurableClassLoader.class.isInstance(classLoader)) {
                stringArray = ((ConfigurableClassLoader)ConfigurableClassLoader.class.cast(classLoader)).getJvmMarkers();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            }
            ConfigurableClassLoader volatileLoader = new ConfigurableClassLoader(string, urls.toArray(new URL[0]), classLoader, predicate, predicate2, nested.toArray(new String[0]), stringArray);
            return new ClassLoaderDescriptorImpl(volatileLoader, resolved);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Collection<File> resolveFromDescriptor(InputStream descriptor) {
        try {
            return new MvnDependencyListLocalRepositoryResolver(null, this.fileResolver).resolveFromDescriptor(descriptor).map(Artifact::toPath).map(this.fileResolver).map(Path::toFile).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializableService(this.plugin, Resolver.class.getName());
    }

    public ResolverImpl(String plugin, Function<String, Path> fileResolver) {
        this.plugin = plugin;
        this.fileResolver = fileResolver;
    }

    private static class ClassLoaderDescriptorImpl
    implements Resolver.ClassLoaderDescriptor {
        private final ConfigurableClassLoader volatileLoader;
        private final Collection<String> resolved;

        @Override
        public ClassLoader asClassLoader() {
            return this.volatileLoader;
        }

        @Override
        public Collection<String> resolvedDependencies() {
            return this.resolved;
        }

        @Override
        public void close() throws Exception {
            this.volatileLoader.close();
        }

        public ClassLoaderDescriptorImpl(ConfigurableClassLoader volatileLoader, Collection<String> resolved) {
            this.volatileLoader = volatileLoader;
            this.resolved = resolved;
        }
    }
}

