/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.xbean;

import java.util.HashSet;
import java.util.Set;
import org.apache.xbean.finder.filter.Filter;

public class KnownClassesFilter
implements Filter {
    public static final Filter INSTANCE = new KnownClassesFilter();
    private final Filter delegateSkip;

    private KnownClassesFilter() {
        HashSet<String> excluded = new HashSet<String>();
        excluded.add("avro.shaded");
        excluded.add("com.codehale.metrics");
        excluded.add("com.ctc.wstx");
        excluded.add("com.datastax.driver");
        excluded.add("com.fasterxml.jackson");
        excluded.add("com.google.common");
        excluded.add("com.google.thirdparty");
        excluded.add("com.ibm.wsdl");
        excluded.add("com.jcraft.jsch");
        excluded.add("com.kenai");
        excluded.add("com.sun.istack");
        excluded.add("com.sun.xml");
        excluded.add("com.talend.shaded");
        excluded.add("com.thoughtworks");
        excluded.add("io.jsonwebtoken");
        excluded.add("io.netty");
        excluded.add("io.swagger");
        excluded.add("javax");
        excluded.add("jnr");
        excluded.add("junit");
        excluded.add("net.sf.ehcache");
        excluded.add("net.shibboleth");
        excluded.add("org.aeonbits.owner");
        excluded.add("org.apache");
        excluded.add("org.bouncycastle");
        excluded.add("org.codehaus");
        excluded.add("org.cryptacular");
        excluded.add("org.eclipse");
        excluded.add("org.fusesource");
        excluded.add("org.h2");
        excluded.add("org.hamcrest");
        excluded.add("org.hsqldb");
        excluded.add("org.jasypt");
        excluded.add("org.jboss");
        excluded.add("org.joda");
        excluded.add("org.jose4j");
        excluded.add("org.junit");
        excluded.add("org.jvnet");
        excluded.add("org.metatype");
        excluded.add("org.objectweb");
        excluded.add("org.openejb");
        excluded.add("org.opensaml");
        excluded.add("org.slf4j");
        excluded.add("org.swizzle");
        excluded.add("org.terracotta");
        excluded.add("org.tukaani");
        excluded.add("org.yaml");
        excluded.add("serp");
        this.delegateSkip = new OptimizedExclusionFilter(excluded);
    }

    @Override
    public boolean accept(String name) {
        return !this.delegateSkip.accept(name);
    }

    public Filter getDelegateSkip() {
        return this.delegateSkip;
    }

    public static class OptimizedExclusionFilter
    implements Filter {
        private final Set<String> included;

        private OptimizedExclusionFilter(Set<String> exclusions) {
            this.included = exclusions;
        }

        @Override
        public boolean accept(String name) {
            int dot = name.indexOf(46);
            while (dot > 0) {
                if (this.included.contains(name.substring(0, dot))) {
                    return true;
                }
                dot = name.indexOf(46, dot + 1);
            }
            return this.included.contains(name);
        }

        public Set<String> getIncluded() {
            return this.included;
        }
    }
}

