/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.xbean.converter;

import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import org.apache.xbean.propertyeditor.AbstractConverter;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.runtime.manager.service.record.RecordBuilderFactoryProvider;
import org.talend.sdk.component.runtime.record.RecordBuilderFactoryImpl;

public class SchemaConverter
extends AbstractConverter {
    public static final String ELEMENT_SCHEMA = "elementSchema";
    public static final String PROPS = "props";
    public static final String TYPE = "type";
    public static final String ENTRIES = "entries";
    private final RecordBuilderFactory factory;

    public SchemaConverter() {
        super(Schema.class);
        try {
            RecordBuilderFactoryProvider spi;
            Iterator<RecordBuilderFactoryProvider> spiIterator = ServiceLoader.load(RecordBuilderFactoryProvider.class).iterator();
            RecordBuilderFactoryProvider recordBuilderFactoryProvider = spiIterator.hasNext() ? (spi = spiIterator.next()) : RecordBuilderFactoryImpl::new;
            this.factory = recordBuilderFactoryProvider.apply("null");
        }
        catch (RuntimeException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Object toObjectImpl(String s) {
        if (!s.isEmpty()) {
            JsonObject json = JsonProvider.provider().createReader(new StringReader(s)).readObject();
            return this.toSchema(json);
        }
        return null;
    }

    private Schema toSchema(JsonObject json) {
        if (json == null || json.isNull(TYPE)) {
            return null;
        }
        String type = json.getString(TYPE);
        Schema.Type schemaType = Enum.valueOf(Schema.Type.class, type);
        Schema.Builder builder = this.factory.newSchemaBuilder(schemaType);
        if (schemaType == Schema.Type.RECORD) {
            this.addEntries(builder, json.getJsonArray(ENTRIES));
            this.addEntries(builder, json.getJsonArray("metadatas"));
        } else if (schemaType == Schema.Type.ARRAY) {
            this.treatElementSchema(json, builder::withElementSchema);
        }
        this.addProps(builder::withProp, json);
        JsonValue orderValue = (JsonValue)json.get("order");
        if (orderValue instanceof JsonString) {
            Schema.EntriesOrder order = Schema.EntriesOrder.of(((JsonString)orderValue).getString());
            return builder.build(order);
        }
        return builder.build();
    }

    private void treatElementSchema(JsonObject json, Consumer<Schema> setter) {
        JsonValue elementSchema = (JsonValue)json.get(ELEMENT_SCHEMA);
        if (elementSchema instanceof JsonObject) {
            Schema schema = this.toSchema((JsonObject)elementSchema);
            setter.accept(schema);
        } else if (elementSchema instanceof JsonString) {
            Schema.Type innerType = Schema.Type.valueOf(((JsonString)elementSchema).getString());
            setter.accept(this.factory.newSchemaBuilder(innerType).build());
        }
    }

    private void addEntries(Schema.Builder schemaBuilder, JsonArray entries) {
        if (entries == null || entries.isEmpty()) {
            return;
        }
        entries.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(this::jsonToEntry).forEach(schemaBuilder::withEntry);
    }

    private Schema.Entry jsonToEntry(JsonObject jsonEntry) {
        Schema.Entry.Builder builder;
        block7: {
            block6: {
                JsonValue jsonValue;
                JsonString rawName;
                builder = this.factory.newEntryBuilder();
                Schema.Type schemaType = Enum.valueOf(Schema.Type.class, jsonEntry.getString(TYPE));
                builder.withType(schemaType).withName(jsonEntry.getString("name")).withNullable(jsonEntry.getBoolean("nullable", true)).withMetadata(jsonEntry.getBoolean("metadata", false));
                JsonString comment = jsonEntry.getJsonString("comment");
                if (comment != null) {
                    builder.withComment(comment.getString());
                }
                if ((rawName = jsonEntry.getJsonString("rawName")) != null) {
                    builder.withRawName(rawName.getString());
                }
                if ((jsonValue = (JsonValue)jsonEntry.get("defaultValue")) != null) {
                    this.setDefaultValue(builder, jsonValue);
                }
                if (schemaType == Schema.Type.RECORD) break block6;
                if (schemaType != Schema.Type.ARRAY) break block7;
            }
            this.treatElementSchema(jsonEntry, builder::withElementSchema);
        }
        this.addProps(builder::withProp, jsonEntry);
        return builder.build();
    }

    private void addProps(BiConsumer<String, String> setter, JsonObject object) {
        if (object == null || object.get(PROPS) == null) {
            return;
        }
        JsonObject props = object.getJsonObject(PROPS);
        if (props.isEmpty()) {
            return;
        }
        props.forEach((name, value) -> setter.accept((String)name, ((JsonString)value).getString()));
    }

    private void setDefaultValue(Schema.Entry.Builder entry, JsonValue value) {
        JsonValue.ValueType valueType = value.getValueType();
        if (valueType == JsonValue.ValueType.NUMBER) {
            entry.withDefaultValue(((JsonNumber)value).numberValue());
        } else if (valueType == JsonValue.ValueType.FALSE) {
            entry.withDefaultValue(Boolean.FALSE);
        } else if (valueType == JsonValue.ValueType.TRUE) {
            entry.withDefaultValue(Boolean.TRUE);
        } else if (valueType == JsonValue.ValueType.STRING) {
            entry.withDefaultValue(((JsonString)value).getString());
        }
    }

    public JsonObject toJson(Schema schema) {
        Schema.EntriesOrder order;
        JsonObject elementSchema;
        if (schema == null) {
            return null;
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add(TYPE, schema.getType().name());
        if (schema.getType() == Schema.Type.RECORD) {
            this.addEntries(builder, ENTRIES, schema.getAllEntries());
        } else if (schema.getType() == Schema.Type.ARRAY && (elementSchema = this.toJson(schema.getElementSchema())) != null) {
            builder.add(ELEMENT_SCHEMA, elementSchema);
        }
        this.addProps(builder, schema.getProps());
        if (schema.getType() == Schema.Type.RECORD && (order = schema.naturalOrder()) != null) {
            String orderValue = order.getFieldsOrder().collect(Collectors.joining(","));
            builder.add("order", orderValue);
        }
        return builder.build();
    }

    private void addEntries(JsonObjectBuilder objectBuilder, String name, Stream<Schema.Entry> entries) {
        if (entries == null) {
            return;
        }
        JsonArrayBuilder jsonEntries = Json.createArrayBuilder();
        objectBuilder.add(name, jsonEntries);
        entries.map(this::entryToJson).forEach(jsonEntries::add);
    }

    private JsonObjectBuilder entryToJson(Schema.Entry entry) {
        JsonValue jsonValue;
        JsonObjectBuilder entryBuilder = Json.createObjectBuilder();
        entryBuilder.add("name", entry.getName());
        entryBuilder.add(TYPE, entry.getType().name());
        entryBuilder.add("nullable", entry.isNullable());
        if (entry.getComment() != null) {
            entryBuilder.add("comment", entry.getComment());
        }
        if (entry.getRawName() != null) {
            entryBuilder.add("rawName", entry.getRawName());
        }
        if (entry.isMetadata()) {
            entryBuilder.add("metadata", true);
        }
        if (entry.getDefaultValue() != null && (jsonValue = this.toValue(entry.getDefaultValue())) != null) {
            entryBuilder.add("defaultValue", jsonValue);
        }
        if (entry.getType() == Schema.Type.RECORD || entry.getType() == Schema.Type.ARRAY) {
            Schema innerSchema = entry.getElementSchema();
            if (innerSchema.getType() == Schema.Type.ARRAY || innerSchema.getType() == Schema.Type.RECORD) {
                JsonObject elementSchema = this.toJson(innerSchema);
                entryBuilder.add(ELEMENT_SCHEMA, elementSchema);
            } else {
                entryBuilder.add(ELEMENT_SCHEMA, innerSchema.getType().name());
            }
        }
        this.addProps(entryBuilder, entry.getProps());
        return entryBuilder;
    }

    private void addProps(JsonObjectBuilder builder, Map<String, String> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        JsonObjectBuilder jsonProps = Json.createObjectBuilder();
        properties.entrySet().forEach(e -> jsonProps.add((String)e.getKey(), (String)e.getValue()));
        builder.add(PROPS, jsonProps);
    }

    private JsonValue toValue(Object object) {
        if (object == null) {
            return JsonValue.NULL;
        }
        if (object instanceof Integer) {
            return Json.createValue((Integer)object);
        }
        if (object instanceof Long) {
            return Json.createValue((Long)object);
        }
        if (object instanceof Double || object instanceof Float) {
            return Json.createValue((Double)object);
        }
        if (object instanceof BigInteger) {
            return Json.createValue((BigInteger)object);
        }
        if (object instanceof Boolean) {
            if (object == Boolean.TRUE) {
                return JsonValue.TRUE;
            }
            return JsonValue.FALSE;
        }
        if (object instanceof BigDecimal) {
            return Json.createValue((BigDecimal)object);
        }
        if (object instanceof String) {
            return Json.createValue((String)object);
        }
        return null;
    }
}

