/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.xbean.converter;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.apache.xbean.propertyeditor.AbstractConverter;

public class ZonedDateTimeConverter
extends AbstractConverter {
    private static final LocalTime NO_TIME = LocalTime.of(0, 0);
    private static final LocalDate NO_DATE = LocalDate.of(1970, 1, 1);
    private static final ZoneId UTC = ZoneId.of("UTC");

    public ZonedDateTimeConverter() {
        super(ZonedDateTime.class);
    }

    @Override
    protected Object toObjectImpl(String data) {
        if (data.isEmpty()) {
            return null;
        }
        String text = data.replace('/', '-');
        switch (text.length()) {
            case 10: {
                return ZonedDateTime.of(LocalDate.parse(text), NO_TIME, ZoneId.of("UTC"));
            }
            case 5: 
            case 8: 
            case 12: 
            case 15: 
            case 18: {
                return ZonedDateTime.of(NO_DATE, LocalTime.parse(text), UTC);
            }
        }
        text = text.replace(' ', 'T');
        if (text.contains("+") || text.contains("[")) {
            int keepAsIt = text.indexOf(43);
            if (keepAsIt < 0) {
                keepAsIt = text.indexOf(91);
            }
            text = text.substring(0, keepAsIt) + data.substring(keepAsIt);
            return ZonedDateTime.parse(text);
        }
        LocalDateTime dateTime = LocalDateTime.parse(text.endsWith("Z") ? text.substring(0, text.length() - 1) : text);
        return ZonedDateTime.of(dateTime.toLocalDate(), dateTime.toLocalTime(), UTC);
    }
}

