/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.xbean.registry;

import java.lang.reflect.Type;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.xbean.propertyeditor.AbstractConverter;
import org.apache.xbean.propertyeditor.BigDecimalEditor;
import org.apache.xbean.propertyeditor.BigIntegerEditor;
import org.apache.xbean.propertyeditor.BooleanEditor;
import org.apache.xbean.propertyeditor.CharacterEditor;
import org.apache.xbean.propertyeditor.ClassEditor;
import org.apache.xbean.propertyeditor.Converter;
import org.apache.xbean.propertyeditor.DateEditor;
import org.apache.xbean.propertyeditor.DoubleEditor;
import org.apache.xbean.propertyeditor.FileEditor;
import org.apache.xbean.propertyeditor.HashMapEditor;
import org.apache.xbean.propertyeditor.HashtableEditor;
import org.apache.xbean.propertyeditor.Inet4AddressEditor;
import org.apache.xbean.propertyeditor.Inet6AddressEditor;
import org.apache.xbean.propertyeditor.InetAddressEditor;
import org.apache.xbean.propertyeditor.ListEditor;
import org.apache.xbean.propertyeditor.MapEditor;
import org.apache.xbean.propertyeditor.ObjectNameEditor;
import org.apache.xbean.propertyeditor.PatternConverter;
import org.apache.xbean.propertyeditor.PropertiesEditor;
import org.apache.xbean.propertyeditor.PropertyEditorRegistry;
import org.apache.xbean.propertyeditor.SetEditor;
import org.apache.xbean.propertyeditor.SortedMapEditor;
import org.apache.xbean.propertyeditor.SortedSetEditor;
import org.apache.xbean.propertyeditor.StringEditor;
import org.apache.xbean.propertyeditor.URIEditor;
import org.apache.xbean.propertyeditor.URLEditor;
import org.talend.sdk.component.runtime.manager.util.Lazy;
import org.talend.sdk.component.runtime.manager.xbean.converter.LocalDateConverter;
import org.talend.sdk.component.runtime.manager.xbean.converter.LocalDateTimeConverter;
import org.talend.sdk.component.runtime.manager.xbean.converter.LocalTimeConverter;
import org.talend.sdk.component.runtime.manager.xbean.converter.SchemaConverter;
import org.talend.sdk.component.runtime.manager.xbean.converter.ZonedDateTimeConverter;

public class EnrichedPropertyEditorRegistry
extends PropertyEditorRegistry {
    private final ThreadLocal<Map<Type, Optional<Converter>>> converterCache = new ThreadLocal();

    public EnrichedPropertyEditorRegistry() {
        final DoubleEditor doubleEditor = new DoubleEditor();
        BiFunction<Class, Function, Converter> numberConverter = (type, mapper) -> new AbstractConverter((Class)type, (Function)mapper){
            final /* synthetic */ Function val$mapper;
            {
                this.val$mapper = function;
                super(type);
            }

            @Override
            protected Object toObjectImpl(String text) {
                if (text.isEmpty()) {
                    return null;
                }
                Object o = doubleEditor.toObject(text);
                return this.val$mapper.apply((Double)Double.class.cast(o));
            }
        };
        super.register(new BooleanEditor());
        super.register(numberConverter.apply(Byte.class, Double::byteValue));
        super.register(numberConverter.apply(Short.class, Double::shortValue));
        super.register(numberConverter.apply(Integer.class, Double::intValue));
        super.register(numberConverter.apply(Long.class, Double::longValue));
        super.register(numberConverter.apply(Float.class, Double::floatValue));
        super.register(doubleEditor);
        super.register(new BigDecimalEditor());
        super.register(new BigIntegerEditor());
        super.register(new StringEditor());
        super.register(new CharacterEditor());
        super.register(new ClassEditor());
        super.register(new LazyDateEditor());
        super.register(new FileEditor());
        super.register(new HashMapEditor());
        super.register(new HashtableEditor());
        super.register(new Inet4AddressEditor());
        super.register(new Inet6AddressEditor());
        super.register(new InetAddressEditor());
        super.register(new ListEditor());
        super.register(new SetEditor());
        super.register(new MapEditor());
        super.register(new SortedMapEditor());
        super.register(new SortedSetEditor());
        super.register(new ObjectNameEditor());
        super.register(new PropertiesEditor());
        super.register(new URIEditor());
        super.register(new URLEditor());
        super.register(new PatternConverter());
        super.register(new LazyZonedDateTimeConverter());
        super.register(new LocalDateTimeConverter());
        super.register(new LocalDateConverter());
        super.register(new LocalTimeConverter());
        super.register(new SchemaConverter());
        ServiceLoader.load(Converter.class).forEach(this::register);
    }

    @Override
    public Converter findConverter(Type type) {
        Map<Type, Optional<Converter>> cache = this.converterCache.get();
        if (cache == null) {
            this.converterCache.remove();
            return this.doFindConverter(type);
        }
        return Optional.ofNullable(cache.get(type)).flatMap(c -> c).orElseGet(() -> {
            Converter converter = this.doFindConverter(type);
            cache.put(type, Optional.ofNullable(converter));
            return converter;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withCache(Map<Type, Optional<Converter>> cache, Supplier<T> task) {
        this.converterCache.set(cache);
        try {
            T t = task.get();
            return t;
        }
        finally {
            this.converterCache.remove();
        }
    }

    private Converter doFindConverter(Type type) {
        return Stream.of(() -> this.findInternalConverter(type), () -> this.findStructuralConverter(type)).map(Supplier::get).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public Converter register(Converter converter) {
        Map<Type, Optional<Converter>> cache = this.converterCache.get();
        if (cache != null) {
            cache.putIfAbsent(converter.getType(), Optional.ofNullable(converter));
        } else {
            this.converterCache.remove();
        }
        return converter;
    }

    private static class LazyDateEditor
    extends LazyEditor<DateEditor> {
        private LazyDateEditor() {
            super(Lazy.lazy(DateEditor::new), Date.class);
        }
    }

    private static class LazyZonedDateTimeConverter
    extends LazyEditor<ZonedDateTimeConverter> {
        private LazyZonedDateTimeConverter() {
            super(Lazy.lazy(ZonedDateTimeConverter::new), Date.class);
        }
    }

    private static class LazyEditor<T extends AbstractConverter>
    extends AbstractConverter {
        private final Supplier<T> delegate;

        private LazyEditor(Supplier<T> delegate, Class<?> type) {
            super(type);
            this.delegate = delegate;
        }

        @Override
        protected String toStringImpl(Object value) {
            return ((AbstractConverter)this.delegate.get()).toString(value);
        }

        @Override
        protected Object toObjectImpl(String text) {
            return ((AbstractConverter)this.delegate.get()).toObject(text);
        }
    }
}

