/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.singer.java;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import org.talend.sdk.component.singer.java.IO;

public class Singer {
    private final IO runIo;
    private final Supplier<ZonedDateTime> dateTimeSupplier;
    private final JsonBuilderFactory builderFactory = Json.createBuilderFactory(Collections.emptyMap());
    private final DateTimeFormatter rfc339 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'").withZone(ZoneId.of("UTC"));

    public Singer() {
        this(new IO(), ZonedDateTime::now);
    }

    public String formatDate(ZonedDateTime dateTime) {
        return this.rfc339.format(dateTime);
    }

    public synchronized void writeState(JsonObject state) {
        JsonObject json = this.builderFactory.createObjectBuilder().add("type", "STATE").add("value", state).build();
        this.runIo.getStdout().println(json);
    }

    public synchronized void writeSchema(String stream, JsonObject schema, JsonArray keys, JsonArray bookmarks) {
        JsonObject json = this.builderFactory.createObjectBuilder().add("type", "SCHEMA").add("stream", Objects.requireNonNull(stream, "stream can't be null")).add("schema", schema).add("key_properties", keys).add("bookmark_properties", bookmarks).build();
        this.runIo.getStdout().println(json);
    }

    public synchronized void writeRecord(String stream, JsonObject record) {
        JsonObject json = this.builderFactory.createObjectBuilder().add("type", "RECORD").add("stream", Objects.requireNonNull(stream, "stream can't be null")).add("time_extracted", this.formatDate(this.dateTimeSupplier.get())).add("record", record).build();
        this.runIo.getStdout().println(json);
    }

    public synchronized void stdout(String message) {
        this.runIo.getStdout().println(message);
    }

    public synchronized void stderr(String message) {
        this.runIo.getStderr().println(message);
    }

    public Singer(IO runIo, Supplier<ZonedDateTime> dateTimeSupplier) {
        this.runIo = runIo;
        this.dateTimeSupplier = dateTimeSupplier;
    }
}

