/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.singer.java;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;

public class SingerArgs {
    private final JsonObject config;
    private final JsonObject state;
    private final JsonObject catalog;
    private final boolean discover;
    private final String componentFamily;
    private final Map<String, String> otherArgs;

    public SingerArgs(String ... args) {
        String config = null;
        String state = null;
        String catalog = null;
        String family = null;
        boolean discover = false;
        HashMap<String, String> otherArgs = new HashMap<String, String>();
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException("No --config");
        }
        block14: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg == null) continue;
            switch (arg) {
                case "--config": {
                    config = args[i + 1];
                    ++i;
                    continue block14;
                }
                case "--state": {
                    state = args[i + 1];
                    ++i;
                    continue block14;
                }
                case "--catalog": {
                    catalog = args[i + 1];
                    ++i;
                    continue block14;
                }
                case "--component-family": {
                    family = args[i + 1];
                    ++i;
                    continue block14;
                }
                case "--discover": {
                    discover = true;
                    continue block14;
                }
                default: {
                    if (!arg.startsWith("--")) continue block14;
                    otherArgs.put(arg, i + 1 < args.length ? args[i + 1] : "true");
                    ++i;
                }
            }
        }
        if (config == null) {
            throw new IllegalArgumentException("No --config");
        }
        JsonReaderFactory readerFactory = Json.createReaderFactory(Collections.emptyMap());
        this.config = this.readObject(readerFactory, config);
        this.state = Optional.ofNullable(state).map(it -> this.readObject(readerFactory, (String)it)).orElse(null);
        this.catalog = Optional.ofNullable(catalog).map(it -> this.readObject(readerFactory, (String)it)).orElse(null);
        this.discover = discover;
        this.componentFamily = family;
        this.otherArgs = otherArgs;
    }

    public Optional<JsonObject> getState() {
        return Optional.ofNullable(this.state);
    }

    public Optional<JsonObject> getCatalog() {
        return Optional.ofNullable(this.catalog);
    }

    public Optional<String> getComponentFamily() {
        return Optional.ofNullable(this.componentFamily);
    }

    private JsonObject readObject(JsonReaderFactory factory, String path) {
        Path source = SingerArgs.get(path);
        if (!Files.exists(source, new LinkOption[0])) {
            throw new IllegalArgumentException("No file available at '" + source + "'");
        }
        JsonReader jsonReader = factory.createReader(Files.newInputStream(source, new OpenOption[0]));
        try {
            JsonObject jsonObject = jsonReader.readObject();
            if (jsonReader != null) {
                jsonReader.close();
            }
            return jsonObject;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private static Path get(String path) {
        String p = path;
        if (p.startsWith("/") && p.indexOf(58) == 2) {
            p = p.substring(1);
        }
        return Paths.get(p, new String[0]);
    }

    public SingerArgs(JsonObject config, JsonObject state, JsonObject catalog, boolean discover, String componentFamily, Map<String, String> otherArgs) {
        this.config = config;
        this.state = state;
        this.catalog = catalog;
        this.discover = discover;
        this.componentFamily = componentFamily;
        this.otherArgs = otherArgs;
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public boolean isDiscover() {
        return this.discover;
    }

    public Map<String, String> getOtherArgs() {
        return this.otherArgs;
    }
}

