/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.singer.kitap;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import org.talend.sdk.component.path.PathFactory;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.singer.java.SingerArgs;
import org.talend.sdk.component.singer.kitap.EnvironmentSetup;
import org.talend.sdk.component.singer.kitap.Kitap;

public final class Carpates {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        EnvironmentSetup.init();
        SingerArgs singerArgs = new SingerArgs(args);
        Path archive = PathFactory.get(Objects.requireNonNull(Optional.ofNullable(singerArgs.getOtherArgs().get("--component-archive")).orElseGet(() -> System.getenv("TALEND_SINGER_COMPONENT_ARCHIVE")), "--component-archive is required"));
        if (!Files.exists(archive, new LinkOption[0])) {
            throw new IllegalArgumentException("--component-archive does not exist: '" + archive + "'");
        }
        String workDirPath = Optional.ofNullable(singerArgs.getOtherArgs().get("--work-dir")).orElseGet(() -> System.getenv("TALEND_SINGER_WORK_DIR"));
        Path workDir = Optional.ofNullable(workDirPath).map(PathFactory::get).orElseGet(() -> {
            try {
                ZonedDateTime now = ZonedDateTime.now();
                return Files.createTempDirectory(Carpates.class.getName() + "_" + now.getYear() + '-' + now.getMonthValue() + '-' + now.getDayOfMonth() + '_' + now.getHour() + '_' + now.getMinute() + '_' + now.getSecond(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }).toAbsolutePath();
        boolean deleteWorkDir = workDirPath == null || !Files.exists(workDir, new LinkOption[0]);
        Path m2 = workDir.resolve("m2");
        if (!Files.exists(m2, new LinkOption[0])) {
            try {
                Files.createDirectories(m2, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        Path javaBin = PathFactory.get(System.getProperty("java.home")).resolve("bin");
        String java = Stream.of("java", "java.cmd", "java.exe").map(javaBin::resolve).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findAny().map(String::valueOf).orElse("java");
        try {
            Path auditFile = workDir.resolve("maven-deploy.audit.log");
            int exitCode = new ProcessBuilder(java, "-jar", archive.toString(), "maven-deploy", m2.toString()).redirectOutput(auditFile.toFile()).redirectError(ProcessBuilder.Redirect.INHERIT).start().waitFor();
            if (exitCode != 0) {
                Files.copy(auditFile, System.err);
                throw new IllegalStateException("Can't setup the component in the repository, exit code=" + exitCode);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        System.setProperty("org.talend.sdk.component.slf4j.StdLogger.level", "error");
        System.setProperty("talend.component.manager.m2.repository", m2.toString());
        String gav = Carpates.loadComponentGav(archive);
        ComponentManager.instance().addPlugin(gav);
        try {
            new Kitap(args).run();
        }
        finally {
            if (deleteWorkDir) {
                Carpates.deleteDir(workDir);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String loadComponentGav(Path archive) {
        try (JarFile file = new JarFile(archive.toFile());){
            String string;
            block13: {
                InputStream stream = file.getInputStream(file.getEntry("TALEND-INF/metadata.properties"));
                try {
                    Properties properties = new Properties();
                    properties.load(stream);
                    string = Objects.requireNonNull(properties.getProperty("component_coordinates"), "no component_coordinates in '" + archive + "'");
                    if (stream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void deleteDir(Path workDir) {
        try {
            Files.walkFileTree(workDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return super.visitFile(file, attrs);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return super.postVisitDirectory(dir, exc);
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private Carpates() {
    }
}

