/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.singer.kitap;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Stream;

final class EnvironmentSetup {
    static void init() {
        String baseName = EnvironmentSetup.class.getName();
        if (Boolean.getBoolean(baseName + ".skip")) {
            return;
        }
        if (!Boolean.getBoolean(baseName + ".jul.skip")) {
            EnvironmentSetup.jul();
        }
        if (!Boolean.getBoolean(baseName + ".log4j.skip")) {
            EnvironmentSetup.log4j();
        }
        if (!Boolean.getBoolean(baseName + ".log4j2.skip")) {
            EnvironmentSetup.log4j2();
        }
        if (!Boolean.getBoolean(baseName + ".logback.skip")) {
            EnvironmentSetup.logback();
        }
    }

    private static void jul() {
        Logger root = Logger.getLogger("");
        root.setLevel(Level.SEVERE);
        Handler[] handlers = root.getHandlers();
        Stream.of(handlers).forEach(root::removeHandler);
        ConsoleHandler handler = new ConsoleHandler(){
            {
                this.setFormatter(new UnifiedFormatter());
            }

            @Override
            protected synchronized void setOutputStream(OutputStream out) throws SecurityException {
                super.setOutputStream(new StdErrStream());
            }
        };
        handler.setLevel(Level.SEVERE);
        root.addHandler(handler);
    }

    private static void logback() {
        System.setProperty("logback.configurationFile", "component-kitap-logback.xml");
    }

    private static void log4j2() {
        System.setProperty("log4j2.configurationFile", "component-kitap-log4j2.xml");
    }

    private static void log4j() {
        System.setProperty("log4j.configuration", "component-kitap-log4j.properties");
    }

    private EnvironmentSetup() {
    }

    private static class UnifiedFormatter
    extends Formatter {
        private final ZoneId zone = ZoneId.systemDefault();
        private final ZoneId utc = ZoneId.of("UTC");

        private UnifiedFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            String throwable;
            ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(record.getMillis()), this.zone).withZoneSameInstant(this.utc);
            String date = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(zdt);
            String thread = (long)record.getThreadID() == Thread.currentThread().getId() ? Thread.currentThread().getName() : "thread-" + record.getThreadID();
            String base = '[' + date + "][" + thread + "][" + record.getLevel().getName() + "][" + record.getLoggerName() + "] " + record.getMessage() + System.lineSeparator();
            if (record.getThrown() != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println();
                record.getThrown().printStackTrace(pw);
                pw.close();
                throwable = sw.toString();
            } else {
                throwable = null;
            }
            return base + (throwable == null ? "" : throwable);
        }
    }

    private static class StdErrStream
    extends OutputStream {
        private StdErrStream() {
        }

        @Override
        public void write(int b) {
            System.err.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            System.err.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            System.err.write(b, off, len);
        }

        @Override
        public void flush() {
            System.err.flush();
        }

        @Override
        public void close() {
            this.flush();
        }
    }
}

