/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.singer.kitap;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.stream.JsonCollectors;
import org.talend.sdk.component.api.record.Schema;

public class JsonSchemaGenerator
implements Supplier<JsonObject> {
    private final Collection<Schema.Entry> properties;
    private final JsonBuilderFactory jsonBuilderFactory;

    @Override
    public JsonObject get() {
        JsonObjectBuilder json = this.jsonBuilderFactory.createObjectBuilder();
        json.add("type", this.jsonBuilderFactory.createArrayBuilder().add("null").add("object").build());
        json.add("additionalProperties", false);
        json.add("properties", this.properties.stream().map(this::toJson).collect(JsonCollectors.toJsonObject()));
        return json.build();
    }

    private Map.Entry<String, JsonValue> toJson(Schema.Entry entry) {
        JsonObject schema;
        switch (entry.getType()) {
            case BYTES: 
            case STRING: {
                schema = this.jsonBuilderFactory.createObjectBuilder().add("type", this.types("string", entry.isNullable())).build();
                break;
            }
            case DATETIME: {
                schema = this.jsonBuilderFactory.createObjectBuilder().add("type", this.types("string", entry.isNullable())).add("format", "date-time").build();
                break;
            }
            case DECIMAL: {
                schema = this.jsonBuilderFactory.createObjectBuilder().add("type", this.types("string", entry.isNullable())).build();
                break;
            }
            case BOOLEAN: {
                schema = this.jsonBuilderFactory.createObjectBuilder().add("type", this.types("boolean", entry.isNullable())).build();
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                schema = this.jsonBuilderFactory.createObjectBuilder().add("type", this.types("number", entry.isNullable())).build();
                break;
            }
            case INT: 
            case LONG: {
                schema = this.jsonBuilderFactory.createObjectBuilder().add("type", this.types("integer", entry.isNullable())).build();
                break;
            }
            case RECORD: {
                schema = new JsonSchemaGenerator(entry.getElementSchema().getEntries(), this.jsonBuilderFactory).get();
                break;
            }
            case ARRAY: {
                schema = this.jsonBuilderFactory.createObjectBuilder().add("type", this.types("array", entry.isNullable())).add("items", new JsonSchemaGenerator(entry.getElementSchema().getEntries(), this.jsonBuilderFactory).get()).build();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid entry: " + entry);
            }
        }
        return new AbstractMap.SimpleImmutableEntry<String, JsonValue>(entry.getName(), schema);
    }

    private JsonArrayBuilder types(String type, boolean nullable) {
        JsonArrayBuilder arrayBuilder = this.jsonBuilderFactory.createArrayBuilder();
        if (nullable) {
            arrayBuilder.add("null");
        }
        arrayBuilder.add(type);
        return arrayBuilder;
    }

    public JsonSchemaGenerator(Collection<Schema.Entry> properties, JsonBuilderFactory jsonBuilderFactory) {
        this.properties = properties;
        this.jsonBuilderFactory = jsonBuilderFactory;
    }
}

