/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.singer.kitap;

import java.io.StringReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.runtime.input.Input;
import org.talend.sdk.component.runtime.input.Mapper;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.singer.java.Singer;
import org.talend.sdk.component.singer.java.SingerArgs;
import org.talend.sdk.component.singer.kitap.EnvironmentSetup;
import org.talend.sdk.component.singer.kitap.JsonSchemaGenerator;
import org.talend.sdk.component.singer.kitap.RecordJsonMapper;

public final class Kitap
implements Runnable {
    private final SingerArgs args;
    private final Singer singer;
    private final JsonBuilderFactory jsonBuilderFactory = Json.createBuilderFactory(Collections.emptyMap());
    private final RecordJsonMapper recordJsonMapper;

    public Kitap(String ... args) {
        this(new SingerArgs(args), new Singer());
    }

    public Kitap(SingerArgs args, Singer singer) {
        this.args = args;
        this.singer = singer;
        this.recordJsonMapper = new RecordJsonMapper(this.jsonBuilderFactory, singer);
    }

    @Override
    public void run() {
        List missingConfigs;
        JsonObject componentConfig = Optional.ofNullable(this.args.getConfig().getJsonObject("component")).orElseGet(() -> Optional.ofNullable(this.args.getConfig().getJsonString("component_config")).map(jsonString -> {
            try (JsonReader reader = Json.createReader(new StringReader(jsonString.getString()));){
                JsonObject jsonObject = reader.readObject();
                return jsonObject;
            }
        }).map(json -> json.containsKey("component") ? json.getJsonObject("component") : json).orElseThrow(() -> new IllegalArgumentException("No 'component' or 'component_config' entry in config.json")));
        JsonObject stream = this.args.getCatalog().flatMap(this::extractSelectedStream).orElseGet(() -> this.jsonBuilderFactory.createObjectBuilder().add("stream", "default").build());
        String streamName = stream.getString("stream");
        ComponentManager mgr = ComponentManager.instance();
        if (mgr.find(Stream::of).count() == 0L) {
            mgr.autoDiscoverPlugins(false, true);
        }
        if (!(missingConfigs = Stream.concat(this.args.getComponentFamily().isPresent() ? Stream.of("family") : Stream.empty(), Stream.of("name")).filter(key -> !componentConfig.containsKey(key)).collect(Collectors.toList())).isEmpty()) {
            throw new IllegalArgumentException("Missing component configuration entries: " + missingConfigs);
        }
        String family = this.args.getComponentFamily().orElseGet(() -> componentConfig.getString("family"));
        String name = componentConfig.getString("name");
        int version = componentConfig.getInt("version", 0);
        Map configuration = Optional.ofNullable(componentConfig.getJsonObject("configuration")).map(this::toConfig).orElseGet(Collections::emptyMap);
        Mapper mapper = mgr.findMapper(family, name, version, configuration).orElseThrow(() -> new IllegalArgumentException("Didn't find the component: '" + family + '#' + name + "'"));
        if (this.args.isDiscover()) {
            this.discover(mapper);
        } else {
            this.readAll(this.args.getConfig().getJsonObject("schemaCustomization"), stream, streamName, mapper);
        }
    }

    private void discover(Mapper mapper) {
        JsonObject schema = this.records(mapper).findFirst().map(record -> new JsonSchemaGenerator(record.getSchema().getEntries(), this.jsonBuilderFactory).get()).orElseThrow(() -> new IllegalArgumentException("No record found for " + mapper.rootName() + '#' + mapper.name()));
        JsonArray metadata = schema.getJsonObject("properties").entrySet().stream().collect(this.jsonBuilderFactory::createArrayBuilder, (a, p) -> a.add(this.jsonBuilderFactory.createObjectBuilder().add("metadata", this.jsonBuilderFactory.createObjectBuilder().add("inclusion", "automatic").add("selected-by-default", true)).add("breadcrumb", this.jsonBuilderFactory.createArrayBuilder().add("properties").add((String)p.getKey()))), JsonArrayBuilder::addAll).build();
        String streams = this.jsonBuilderFactory.createObjectBuilder().add("streams", this.jsonBuilderFactory.createArrayBuilder().add(this.jsonBuilderFactory.createObjectBuilder().add("tap_stream_id", "default").add("stream", "default").add("schema", schema).add("metadata", metadata))).build().toString();
        this.singer.stdout(streams);
    }

    private void readAll(JsonObject config, JsonObject stream, String streamName, Mapper mapper) {
        AtomicReference lastSchema = new AtomicReference();
        this.records(mapper).peek(record -> {
            Schema newSchema = record.getSchema();
            if (!newSchema.equals(lastSchema.get())) {
                JsonArray keys = config != null && config.containsKey("keys") ? config.getJsonArray("keys") : this.jsonBuilderFactory.createArrayBuilder().build();
                JsonArray bookmarks = config != null && config.containsKey("bookmarks") ? config.getJsonArray("bookmarks") : this.jsonBuilderFactory.createArrayBuilder().build();
                JsonObject schema = Optional.ofNullable(stream.getJsonObject("schema")).orElseGet(() -> new JsonSchemaGenerator(newSchema.getEntries(), this.jsonBuilderFactory).get());
                this.singer.writeSchema(streamName, schema, keys, bookmarks);
                lastSchema.set(newSchema);
            }
        }).forEach(record -> this.singer.writeRecord(streamName, this.recordJsonMapper.apply((Record)record)));
    }

    private Stream<Record> records(Mapper mapper) {
        return this.createPartitions(mapper).stream().flatMap(m -> {
            Input input = m.create();
            input.start();
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new InputIterator(input), 1024), false);
        });
    }

    private Map<String, String> toConfig(JsonObject object) {
        return object.entrySet().stream().filter(e -> !JsonValue.NULL.equals(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, e -> {
            switch (((JsonValue)e.getValue()).getValueType()) {
                case STRING: {
                    return ((JsonString)JsonString.class.cast(e.getValue())).getString();
                }
                case NUMBER: {
                    return String.valueOf(((JsonNumber)JsonNumber.class.cast(e.getValue())).doubleValue());
                }
                case TRUE: 
                case FALSE: {
                    return String.valueOf(JsonValue.TRUE.equals(e.getValue()));
                }
            }
            throw new IllegalArgumentException("Unsupported json entry: " + e);
        }));
    }

    private Optional<JsonObject> extractSelectedStream(JsonObject jsonObject) {
        return Optional.ofNullable(jsonObject.getJsonArray("streams")).flatMap(streams -> streams.stream().filter(stream -> stream.getValueType() == JsonValue.ValueType.OBJECT).map(JsonValue::asJsonObject).filter(this::hasSelectedProperty).findFirst());
    }

    private boolean hasSelectedProperty(JsonObject stream) {
        return Optional.ofNullable(stream.getJsonObject("schema")).map(schema -> schema.getJsonObject("properties")).map(properties -> properties.values().stream().filter(prop -> prop.getValueType() == JsonValue.ValueType.OBJECT).anyMatch(prop -> prop.asJsonObject().getBoolean("selected", false))).orElse(false);
    }

    private List<Mapper> createPartitions(Mapper mapper) {
        List<Mapper> partitions;
        mapper.start();
        try {
            partitions = Objects.requireNonNull(mapper.split(mapper.assess()), "No mapper created after splitting the source");
        }
        finally {
            mapper.stop();
        }
        return partitions;
    }

    public static void main(String ... args) {
        EnvironmentSetup.init();
        new Kitap(args).run();
    }

    private static final class InputIterator
    implements Iterator<Record> {
        private final Input input;
        private Object next;

        @Override
        public boolean hasNext() {
            boolean hasNext;
            this.next = this.input.next();
            boolean bl = hasNext = this.next != null;
            if (!hasNext) {
                this.input.stop();
            }
            return hasNext;
        }

        @Override
        public Record next() {
            return (Record)Record.class.cast(this.next);
        }

        public InputIterator(Input input) {
            this.input = input;
        }
    }
}

