/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.singer.kitap;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.bind.JsonbConfig;
import javax.json.bind.spi.JsonbProvider;
import javax.json.spi.JsonProvider;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordService;
import org.talend.sdk.component.api.service.record.RecordVisitor;
import org.talend.sdk.component.runtime.manager.service.DefaultServiceProvider;
import org.talend.sdk.component.runtime.record.RecordBuilderFactoryImpl;
import org.talend.sdk.component.singer.java.Singer;

public class RecordJsonMapper
implements Function<Record, JsonObject> {
    private final JsonBuilderFactory jsonBuilderFactory;
    private final Singer singer;
    private final RecordService service = (RecordService)RecordService.class.cast(new DefaultServiceProvider(null, JsonProvider.provider(), Json.createGeneratorFactory(Collections.emptyMap()), Json.createReaderFactory(Collections.emptyMap()), Json.createBuilderFactory(Collections.emptyMap()), Json.createParserFactory(Collections.emptyMap()), Json.createWriterFactory(Collections.emptyMap()), new JsonbConfig(), JsonbProvider.provider(), null, null, Collections.emptyList(), t -> new RecordBuilderFactoryImpl("kitap"), null).lookup(null, Thread.currentThread().getContextClassLoader(), null, null, RecordService.class, null, null));

    @Override
    public JsonObject apply(Record record) {
        return this.service.visit(new JsonVisitor(this.singer, this.service, this.jsonBuilderFactory), record);
    }

    public RecordJsonMapper(JsonBuilderFactory jsonBuilderFactory, Singer singer) {
        this.jsonBuilderFactory = jsonBuilderFactory;
        this.singer = singer;
    }

    private static class JsonVisitor
    implements RecordVisitor<JsonObject> {
        private final Singer singer;
        private final RecordService service;
        private final JsonBuilderFactory factory;
        private final JsonObjectBuilder builder;
        private final LinkedList<BiFunction<JsonObject, JsonObject, JsonObject>> stack = new LinkedList();

        private JsonVisitor(Singer singer, RecordService service, JsonBuilderFactory jsonBuilderFactory) {
            this.singer = singer;
            this.service = service;
            this.factory = jsonBuilderFactory;
            this.builder = jsonBuilderFactory.createObjectBuilder();
        }

        @Override
        public JsonObject get() {
            return this.builder.build();
        }

        @Override
        public JsonObject apply(JsonObject t1, JsonObject t2) {
            return this.stack.removeLast().apply(t1, t2);
        }

        @Override
        public void onInt(Schema.Entry entry, OptionalInt optionalInt) {
            optionalInt.ifPresent(v -> this.builder.add(entry.getName(), v));
        }

        @Override
        public void onLong(Schema.Entry entry, OptionalLong optionalLong) {
            optionalLong.ifPresent(v -> this.builder.add(entry.getName(), v));
        }

        @Override
        public void onFloat(Schema.Entry entry, OptionalDouble optionalFloat) {
            optionalFloat.ifPresent(v -> this.builder.add(entry.getName(), v));
        }

        @Override
        public void onDouble(Schema.Entry entry, OptionalDouble optionalDouble) {
            optionalDouble.ifPresent(v -> this.builder.add(entry.getName(), v));
        }

        @Override
        public void onBoolean(Schema.Entry entry, Optional<Boolean> optionalBoolean) {
            optionalBoolean.ifPresent(v -> this.builder.add(entry.getName(), (boolean)v));
        }

        @Override
        public void onString(Schema.Entry entry, Optional<String> string) {
            string.ifPresent(v -> this.builder.add(entry.getName(), (String)v));
        }

        @Override
        public void onDatetime(Schema.Entry entry, Optional<ZonedDateTime> dateTime) {
            dateTime.ifPresent(v -> this.builder.add(entry.getName(), this.singer.formatDate((ZonedDateTime)v)));
        }

        @Override
        public void onInstant(Schema.Entry entry, Optional<Instant> dateTime) {
            dateTime.ifPresent(v -> this.builder.add(entry.getName(), this.singer.formatDate(ZonedDateTime.ofInstant(v, ZoneId.of("UTC")))));
        }

        @Override
        public void onDecimal(Schema.Entry entry, Optional<BigDecimal> decimal) {
            decimal.ifPresent(v -> this.builder.add(entry.getName(), v.toString()));
        }

        @Override
        public void onBytes(Schema.Entry entry, Optional<byte[]> bytes) {
            bytes.ifPresent(v -> this.builder.add(entry.getName(), Base64.getEncoder().encodeToString((byte[])v)));
        }

        @Override
        public RecordVisitor<JsonObject> onRecord(Schema.Entry entry, Optional<Record> record) {
            this.stack.add((o1, o2) -> this.factory.createObjectBuilder((JsonObject)o2).add(entry.getName(), (JsonValue)JsonObject.class.cast(o1)).build());
            return new JsonVisitor(this.singer, this.service, this.factory);
        }

        @Override
        public void onIntArray(Schema.Entry entry, Optional<Collection<Integer>> array) {
            array.ifPresent(vs -> this.builder.add(entry.getName(), vs.stream().collect(this.factory::createArrayBuilder, JsonArrayBuilder::add, JsonArrayBuilder::addAll).build()));
        }

        @Override
        public void onLongArray(Schema.Entry entry, Optional<Collection<Long>> array) {
            array.ifPresent(vs -> this.builder.add(entry.getName(), vs.stream().collect(this.factory::createArrayBuilder, JsonArrayBuilder::add, JsonArrayBuilder::addAll).build()));
        }

        @Override
        public void onFloatArray(Schema.Entry entry, Optional<Collection<Float>> array) {
            array.ifPresent(vs -> this.builder.add(entry.getName(), vs.stream().collect(this.factory::createArrayBuilder, JsonArrayBuilder::add, JsonArrayBuilder::addAll).build()));
        }

        @Override
        public void onDoubleArray(Schema.Entry entry, Optional<Collection<Double>> array) {
            array.ifPresent(vs -> this.builder.add(entry.getName(), vs.stream().collect(this.factory::createArrayBuilder, JsonArrayBuilder::add, JsonArrayBuilder::addAll).build()));
        }

        @Override
        public void onBooleanArray(Schema.Entry entry, Optional<Collection<Boolean>> array) {
            array.ifPresent(vs -> this.builder.add(entry.getName(), vs.stream().collect(this.factory::createArrayBuilder, JsonArrayBuilder::add, JsonArrayBuilder::addAll).build()));
        }

        @Override
        public void onStringArray(Schema.Entry entry, Optional<Collection<String>> array) {
            array.ifPresent(vs -> this.builder.add(entry.getName(), vs.stream().collect(this.factory::createArrayBuilder, JsonArrayBuilder::add, JsonArrayBuilder::addAll).build()));
        }

        @Override
        public void onDatetimeArray(Schema.Entry entry, Optional<Collection<ZonedDateTime>> array) {
            array.ifPresent(vs -> this.builder.add(entry.getName(), vs.stream().map(this.singer::formatDate).collect(this.factory::createArrayBuilder, JsonArrayBuilder::add, JsonArrayBuilder::addAll).build()));
        }

        @Override
        public void onDecimalArray(Schema.Entry entry, Optional<Collection<BigDecimal>> array) {
            array.ifPresent(vs -> this.builder.add(entry.getName(), vs.stream().map(v -> v.toString()).collect(this.factory::createArrayBuilder, JsonArrayBuilder::add, JsonArrayBuilder::addAll).build()));
        }

        @Override
        public void onBytesArray(Schema.Entry entry, Optional<Collection<byte[]>> array) {
            array.ifPresent(vs -> this.builder.add(entry.getName(), vs.stream().map(it -> Base64.getEncoder().encodeToString((byte[])it)).collect(this.factory::createArrayBuilder, JsonArrayBuilder::add, JsonArrayBuilder::addAll).build()));
        }

        @Override
        public RecordVisitor<JsonObject> onRecordArray(Schema.Entry entry, Optional<Collection<Record>> array) {
            array.ifPresent(vs -> this.builder.add(entry.getName(), vs.stream().map(it -> this.service.visit(new JsonVisitor(this.singer, this.service, this.factory), (Record)it)).collect(this.factory::createArrayBuilder, JsonArrayBuilder::add, JsonArrayBuilder::addAll).build()));
            return new RecordVisitor<JsonObject>(){};
        }
    }
}

