/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit.beam;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.bind.Jsonb;
import javax.json.spi.JsonProvider;
import lombok.Generated;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.runtime.beam.coder.JsonbCoder;
import org.talend.sdk.component.runtime.beam.coder.JsonpJsonObjectCoder;
import org.talend.sdk.component.runtime.beam.coder.registry.SchemaRegistryCoder;
import org.talend.sdk.component.runtime.beam.spi.record.RecordCollectors;
import org.talend.sdk.component.runtime.record.RecordConverters;
import org.talend.sdk.component.runtime.serialization.ContainerFinder;
import org.talend.sdk.component.runtime.serialization.LightContainer;

public class Data {
    public static final RecordConverters.MappingMetaRegistry REGISTRY = new RecordConverters.MappingMetaRegistry();

    public static <T> PTransform<PCollection<Record>, PCollection<Map<String, T>>> map(String plugin, Class<T> expectedRecordType) {
        return new DataMapper<T>(plugin, expectedRecordType);
    }

    public static Create.Values<Record> of(final String plugin, Iterable<Map<String, List<?>>> elems) {
        return Create.of(() -> {
            final Iterator delegate = elems.iterator();
            return new Iterator<Record>(){
                private volatile transient RecordConverters converters;
                private volatile transient Jsonb jsonb;
                private volatile transient RecordBuilderFactory recordBuilderFactory;

                @Override
                public boolean hasNext() {
                    return delegate.hasNext();
                }

                @Override
                public Record next() {
                    return this.map((Map)delegate.next());
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private Record map(Map<String, List<?>> next) {
                    if (next == null) {
                        return null;
                    }
                    if (this.converters == null) {
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            if (this.converters == null) {
                                LightContainer container = ContainerFinder.Instance.get().find(plugin);
                                this.recordBuilderFactory = (RecordBuilderFactory)container.findService(RecordBuilderFactory.class);
                                this.jsonb = (Jsonb)container.findService(Jsonb.class);
                                this.converters = new RecordConverters();
                            }
                        }
                    }
                    return next.entrySet().stream().filter(it -> !((List)it.getValue()).isEmpty()).collect(() -> ((RecordBuilderFactory)this.recordBuilderFactory).newRecordBuilder(), (aggregator, entry) -> {
                        List list = ((List)entry.getValue()).stream().map((? super T it) -> (Record)Record.class.cast(this.converters.toRecord(REGISTRY, it, () -> this.jsonb, () -> this.recordBuilderFactory))).collect(Collectors.toList());
                        aggregator.withArray(this.recordBuilderFactory.newEntryBuilder().withName((String)entry.getKey()).withType(Schema.Type.ARRAY).withElementSchema(((Record)list.iterator().next()).getSchema()).build(), list).build();
                    }, RecordCollectors::merge).build();
                }
            };
        }).withCoder((Coder)SchemaRegistryCoder.of());
    }

    @Generated
    private Data() {
    }

    private static class DataMapper<T>
    extends PTransform<PCollection<Record>, PCollection<Map<String, T>>> {
        private String plugin;
        private Class<T> type;

        protected Coder<?> getDefaultOutputCoder() {
            return MapCoder.of((Coder)StringUtf8Coder.of(), (Coder)SchemaRegistryCoder.of());
        }

        public PCollection<Map<String, T>> expand(PCollection<Record> collection) {
            return (PCollection)collection.apply((PTransform)ParDo.of(new DataMapperFn((Coder<JsonObject>)JsonpJsonObjectCoder.of((String)this.plugin), JsonbCoder.of(this.type, (String)this.plugin), this.plugin, new RecordConverters(), new RecordConverters.MappingMetaRegistry())));
        }

        @Generated
        protected DataMapper() {
        }

        @Generated
        private DataMapper(String plugin, Class<T> type) {
            this.plugin = plugin;
            this.type = type;
        }
    }

    private static class DataMapperFn<T>
    extends DoFn<Record, Map<String, T>> {
        private Coder<JsonObject> jsonpCoder;
        private JsonbCoder<T> jsonbCoder;
        private String plugin;
        private RecordConverters converters;
        private volatile RecordConverters.MappingMetaRegistry registry;

        @DoFn.ProcessElement
        public void onElement(DoFn.ProcessContext context) {
            context.output(this.map((Record)context.element()));
        }

        private Map<String, T> map(Record object) {
            if (this.registry == null) {
                this.registry = new RecordConverters.MappingMetaRegistry();
            }
            return object.getSchema().getAllEntries().collect(Collectors.toMap(Schema.Entry::getName, e -> {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Record record = (Record)object.getArray(Record.class, e.getName()).iterator().next();
                    JsonObject jsonObject = (JsonObject)JsonObject.class.cast(this.converters.toType(this.registry, (Object)record, JsonObject.class, this::getJsonBuilder, this::getJsonProvider, this::getJsonb, this::getRecordBuilderFactory));
                    if (Record.class == this.jsonbCoder.getType()) {
                        return new RecordConverters().toRecord(REGISTRY, (Object)jsonObject, this::getJsonb, this::getRecordBuilderFactory);
                    }
                    this.jsonpCoder.encode((Object)jsonObject, (OutputStream)baos);
                    return this.jsonbCoder.decode((InputStream)new ByteArrayInputStream(baos.toByteArray()));
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }));
        }

        private LightContainer getContainer() {
            return ContainerFinder.Instance.get().find(this.plugin);
        }

        private RecordBuilderFactory getRecordBuilderFactory() {
            return (RecordBuilderFactory)this.getContainer().findService(RecordBuilderFactory.class);
        }

        private JsonBuilderFactory getJsonBuilder() {
            return (JsonBuilderFactory)this.getContainer().findService(JsonBuilderFactory.class);
        }

        private JsonProvider getJsonProvider() {
            return (JsonProvider)this.getContainer().findService(JsonProvider.class);
        }

        private Jsonb getJsonb() {
            return (Jsonb)this.getContainer().findService(Jsonb.class);
        }

        @Generated
        protected DataMapperFn() {
        }

        @Generated
        private DataMapperFn(Coder<JsonObject> jsonpCoder, JsonbCoder<T> jsonbCoder, String plugin, RecordConverters converters, RecordConverters.MappingMetaRegistry registry) {
            this.jsonpCoder = jsonpCoder;
            this.jsonbCoder = jsonbCoder;
            this.plugin = plugin;
            this.converters = converters;
            this.registry = registry;
        }
    }
}

