/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.talend.sdk.component.runtime.base.Delegated;
import org.talend.sdk.component.runtime.base.Serializer;
import org.talend.sdk.component.runtime.beam.error.ErrorFactory;
import org.talend.sdk.component.runtime.beam.impl.BeamInput;
import org.talend.sdk.component.runtime.beam.impl.BeamProcessorChainImpl;
import org.talend.sdk.component.runtime.beam.impl.CapturingPipeline;
import org.talend.sdk.component.runtime.input.Input;
import org.talend.sdk.component.runtime.input.Mapper;
import org.talend.sdk.component.runtime.output.Processor;
import org.talend.sdk.component.runtime.serialization.ContainerFinder;
import org.talend.sdk.component.runtime.serialization.EnhancedObjectInputStream;

public class BeamMapperImpl
implements Mapper,
Serializable,
Delegated {
    private final PipelineOptions options = PipelineOptionsFactory.create();
    private final Object original;
    private final FlowDefinition flow;
    private final String family;
    private final String name;
    private final String plugin;
    private final ClassLoader loader;

    public BeamMapperImpl(PTransform<PBegin, ?> begin, String plugin, String family, String name) {
        this(begin, BeamMapperImpl.createFlowDefinition(begin, plugin, family, name), plugin, family, name);
    }

    protected BeamMapperImpl(Object original, FlowDefinition flow, String plugin, String family, String name) {
        this.original = original;
        this.flow = flow;
        this.plugin = plugin;
        this.family = family;
        this.name = name;
        this.loader = ContainerFinder.Instance.get().find(this.plugin()).classloader();
    }

    public long assess() {
        return this.execute(() -> {
            try {
                return BoundedSource.class.isInstance(this.flow.source) ? ((BoundedSource)BoundedSource.class.cast(this.flow.source)).getEstimatedSizeBytes(this.options) : 1L;
            }
            catch (Exception e) {
                throw ErrorFactory.toIllegalState(e);
            }
        });
    }

    public List<Mapper> split(long desiredSize) {
        return Collections.singletonList(this);
    }

    public Input create() {
        return this.execute(() -> {
            try {
                boolean isBounded = BoundedSource.class.isInstance(this.flow.source);
                BoundedSource.BoundedReader reader = isBounded ? ((BoundedSource)BoundedSource.class.cast(this.flow.source)).createReader(this.options) : ((UnboundedSource)UnboundedSource.class.cast(this.flow.source)).createReader(this.options, null);
                return new BeamInput((Source.Reader<?>)reader, this.flow.processor, this.plugin, this.family, this.name, this.loader, isBounded ? 0L : 30L);
            }
            catch (IOException e) {
                throw ErrorFactory.toIllegalArgument(e);
            }
        });
    }

    public boolean isStream() {
        return UnboundedSource.class.isInstance(this.flow.source);
    }

    public String plugin() {
        return this.plugin;
    }

    public String rootName() {
        return this.family;
    }

    public String name() {
        return this.name;
    }

    public void start() {
    }

    public void stop() {
    }

    public Object getDelegate() {
        return this.original;
    }

    private <T> T execute(Supplier<T> task) {
        Thread thread = Thread.currentThread();
        ClassLoader tccl = thread.getContextClassLoader();
        thread.setContextClassLoader(this.loader);
        try {
            T t = task.get();
            return t;
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ErrorFactory.toIllegalState(ex);
        }
        finally {
            thread.setContextClassLoader(tccl);
        }
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializationReplacer(this.plugin(), this.rootName(), this.name(), Serializer.toBytes((Object)this.flow));
    }

    private static FlowDefinition createFlowDefinition(PTransform<PBegin, ?> begin, String plugin, String family, String name) {
        CapturingPipeline capturingPipeline = new CapturingPipeline(PipelineOptionsFactory.create());
        CapturingPipeline.SourceExtractor sourceExtractor = new CapturingPipeline.SourceExtractor();
        capturingPipeline.apply(begin);
        capturingPipeline.traverseTopologically(sourceExtractor);
        PTransform<? super PBegin, ?> transform = sourceExtractor.getTransform();
        if (transform == null) {
            capturingPipeline.apply(begin);
            transform = capturingPipeline.getRoot();
        }
        if (Read.Bounded.class.isInstance(transform)) {
            BeamProcessorChainImpl processor = sourceExtractor.getTransforms().isEmpty() ? null : new BeamProcessorChainImpl(sourceExtractor.getTransforms(), capturingPipeline.getCoderRegistry(), plugin, family, name);
            return new FlowDefinition((Source<?>)((Read.Bounded)Read.Bounded.class.cast(transform)).getSource(), processor);
        }
        if (Read.Unbounded.class.isInstance(transform)) {
            BeamProcessorChainImpl processor = sourceExtractor.getTransforms().isEmpty() ? null : new BeamProcessorChainImpl(sourceExtractor.getTransforms(), capturingPipeline.getCoderRegistry(), plugin, family, name);
            return new FlowDefinition((Source<?>)((Read.Unbounded)Read.Unbounded.class.cast(transform)).getSource(), processor);
        }
        throw new InvalidMapperPipelineException("This implementation only supports Bounded sources");
    }

    private static class SerializationReplacer
    implements Serializable {
        private final String plugin;
        private final String component;
        private final String name;
        private final byte[] value;

        Object readResolve() throws ObjectStreamException {
            try {
                FlowDefinition flow = (FlowDefinition)FlowDefinition.class.cast(this.loadDelegate());
                return new BeamMapperImpl(flow, flow, this.plugin, this.component, this.name);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new InvalidObjectException(e.getMessage());
            }
        }

        private Serializable loadDelegate() throws IOException, ClassNotFoundException {
            try (EnhancedObjectInputStream ois = new EnhancedObjectInputStream((InputStream)new ByteArrayInputStream(this.value), ContainerFinder.Instance.get().find(this.plugin).classloader());){
                Serializable serializable = (Serializable)Serializable.class.cast(ois.readObject());
                return serializable;
            }
        }

        public SerializationReplacer(String plugin, String component, String name, byte[] value) {
            this.plugin = plugin;
            this.component = component;
            this.name = name;
            this.value = value;
        }
    }

    private static class FlowDefinition
    implements Serializable {
        private final Source<?> source;
        private final Processor processor;

        public FlowDefinition(Source<?> source, Processor processor) {
            this.source = source;
            this.processor = processor;
        }

        public Source<?> getSource() {
            return this.source;
        }

        public Processor getProcessor() {
            return this.processor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FlowDefinition)) {
                return false;
            }
            FlowDefinition other = (FlowDefinition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Source<?> this$source = this.getSource();
            Source<?> other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            Processor this$processor = this.getProcessor();
            Processor other$processor = other.getProcessor();
            return !(this$processor == null ? other$processor != null : !this$processor.equals(other$processor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FlowDefinition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Source<?> $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            Processor $processor = this.getProcessor();
            result = result * 59 + ($processor == null ? 43 : $processor.hashCode());
            return result;
        }

        public String toString() {
            return "BeamMapperImpl.FlowDefinition(source=" + this.getSource() + ", processor=" + this.getProcessor() + ")";
        }
    }

    public static class InvalidMapperPipelineException
    extends RuntimeException {
        public InvalidMapperPipelineException(String message) {
            super(message);
        }
    }
}

