/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;

public class CapturingPipeline
extends Pipeline {
    private PTransform<? super PBegin, ?> root;

    CapturingPipeline(PipelineOptions options) {
        super(options);
    }

    public <OutputT extends POutput> OutputT apply(PTransform<? super PBegin, OutputT> root) {
        this.root = root;
        return (OutputT)super.apply(root);
    }

    public <OutputT extends POutput> OutputT apply(String name, PTransform<? super PBegin, OutputT> root) {
        this.root = root;
        return (OutputT)super.apply(name, root);
    }

    public PTransform<? super PBegin, ?> getRoot() {
        return this.root;
    }

    public static class TransformWithCoder {
        private final PTransform<PCollection<?>, ?> transform;
        private final Map<TupleTag<?>, Coder<?>> coders;

        public TransformWithCoder(PTransform<PCollection<?>, ?> transform, Map<TupleTag<?>, Coder<?>> coders) {
            this.transform = transform;
            this.coders = coders;
        }

        public PTransform<PCollection<?>, ?> getTransform() {
            return this.transform;
        }

        public Map<TupleTag<?>, Coder<?>> getCoders() {
            return this.coders;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransformWithCoder)) {
                return false;
            }
            TransformWithCoder other = (TransformWithCoder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PTransform<PCollection<?>, ?> this$transform = this.getTransform();
            PTransform<PCollection<?>, ?> other$transform = other.getTransform();
            if (this$transform == null ? other$transform != null : !this$transform.equals(other$transform)) {
                return false;
            }
            Map<TupleTag<?>, Coder<?>> this$coders = this.getCoders();
            Map<TupleTag<?>, Coder<?>> other$coders = other.getCoders();
            return !(this$coders == null ? other$coders != null : !((Object)this$coders).equals(other$coders));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TransformWithCoder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PTransform<PCollection<?>, ?> $transform = this.getTransform();
            result = result * 59 + ($transform == null ? 43 : $transform.hashCode());
            Map<TupleTag<?>, Coder<?>> $coders = this.getCoders();
            result = result * 59 + ($coders == null ? 43 : ((Object)$coders).hashCode());
            return result;
        }

        public String toString() {
            return "CapturingPipeline.TransformWithCoder(transform=" + this.getTransform() + ", coders=" + this.getCoders() + ")";
        }
    }

    static class SourceExtractor
    implements Pipeline.PipelineVisitor {
        private PTransform<? super PBegin, ?> transform;
        private List<TransformWithCoder> transforms = new ArrayList<TransformWithCoder>();

        SourceExtractor() {
        }

        public void enterPipeline(Pipeline p) {
        }

        public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }

        public void leaveCompositeTransform(TransformHierarchy.Node node) {
        }

        public void visitPrimitiveTransform(TransformHierarchy.Node node) {
            PTransform transform = node.getTransform();
            if (this.transform != null) {
                this.transforms.add(new TransformWithCoder(transform, this.findCoders(node)));
            } else {
                this.transform = transform;
            }
        }

        public void visitValue(PValue value, TransformHierarchy.Node producer) {
        }

        public void leavePipeline(Pipeline pipeline) {
        }

        private Map<TupleTag<?>, Coder<?>> findCoders(TransformHierarchy.Node node) {
            if (node.getOutputs() == null || node.getOutputs().isEmpty()) {
                return null;
            }
            return node.getOutputs().entrySet().stream().filter(e -> PCollection.class.isInstance(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, e -> ((PCollection)PCollection.class.cast(e.getValue())).getCoder()));
        }

        public PTransform<? super PBegin, ?> getTransform() {
            return this.transform;
        }

        public List<TransformWithCoder> getTransforms() {
            return this.transforms;
        }
    }

    static class SinkExtractor
    implements Pipeline.PipelineVisitor {
        private Collection<DoFn<?, ?>> outputs = new ArrayList();

        SinkExtractor() {
        }

        public void enterPipeline(Pipeline p) {
        }

        public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }

        public void leaveCompositeTransform(TransformHierarchy.Node node) {
        }

        public void visitPrimitiveTransform(TransformHierarchy.Node node) {
            PTransform transform = node.getTransform();
            if (!ParDo.MultiOutput.class.isInstance(transform)) {
                return;
            }
            ParDo.MultiOutput multiOutput = (ParDo.MultiOutput)ParDo.MultiOutput.class.cast(transform);
            DoFn fn = multiOutput.getFn();
            this.outputs.add(fn);
        }

        public void visitValue(PValue value, TransformHierarchy.Node producer) {
        }

        public void leavePipeline(Pipeline pipeline) {
        }

        public Collection<DoFn<?, ?>> getOutputs() {
            return this.outputs;
        }
    }
}

