/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.impl;

import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.joda.time.Instant;
import org.talend.sdk.component.runtime.output.InputFactory;
import org.talend.sdk.component.runtime.output.OutputFactory;

public class ContextImplGenericsHolder<I, O>
extends DoFn<I, O> {
    public DoFn.ProcessContext newContext(PipelineOptions options, InputFactory inputs, OutputFactory outputs) {
        return new ProcessContextImpl(options, inputs, outputs);
    }

    public DoFn.StartBundleContext newStartContext(PipelineOptions options) {
        return new StartContextImpl(options);
    }

    public DoFn.FinishBundleContext newFinishContext(PipelineOptions options, OutputFactory outputs) {
        return new FinishContextImpl(options, outputs);
    }

    public class ProcessContextImpl
    extends DoFn.ProcessContext {
        private final PipelineOptions options;
        private final InputFactory inputs;
        private final OutputFactory outputs;

        public I element() {
            return this.inputs.read("__default__");
        }

        public Instant timestamp() {
            return Instant.now();
        }

        public <T> T sideInput(PCollectionView<T> view) {
            throw new UnsupportedOperationException("side inputs not yet supported");
        }

        public PaneInfo pane() {
            return PaneInfo.NO_FIRING;
        }

        public void updateWatermark(Instant watermark) {
            throw new UnsupportedOperationException("watermark not supported");
        }

        public PipelineOptions getPipelineOptions() {
            return this.options;
        }

        public void output(Object output) {
            this.outputs.create("__default__").emit(output);
        }

        public <T> void output(TupleTag<T> tag, T output) {
            this.outputs.create(tag.getId()).emit(output);
        }

        public <T> void outputWithTimestamp(TupleTag<T> tag, T output, Instant timestamp) {
            this.output(output);
        }

        public void outputWithTimestamp(Object output, Instant timestamp) {
            this.output(output);
        }

        public ProcessContextImpl(PipelineOptions options, InputFactory inputs, OutputFactory outputs) {
            super((DoFn)ContextImplGenericsHolder.this);
            this.options = options;
            this.inputs = inputs;
            this.outputs = outputs;
        }
    }

    public class FinishContextImpl
    extends DoFn.FinishBundleContext {
        private final PipelineOptions options;
        private final OutputFactory outputs;

        public PipelineOptions getPipelineOptions() {
            return this.options;
        }

        public void output(O output, Instant timestamp, BoundedWindow window) {
            this.outputs.create("__default__").emit(output);
        }

        public <T> void output(TupleTag<T> tag, T output, Instant timestamp, BoundedWindow window) {
            this.outputs.create(tag.getId()).emit(output);
        }

        public FinishContextImpl(PipelineOptions options, OutputFactory outputs) {
            super((DoFn)ContextImplGenericsHolder.this);
            this.options = options;
            this.outputs = outputs;
        }
    }

    public class StartContextImpl
    extends DoFn.StartBundleContext {
        private final PipelineOptions options;

        public PipelineOptions getPipelineOptions() {
            return this.options;
        }

        public StartContextImpl(PipelineOptions options) {
            super((DoFn)ContextImplGenericsHolder.this);
            this.options = options;
        }
    }
}

