/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.spi.record;

import java.nio.ByteBuffer;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.json.bind.annotation.JsonbTransient;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.util.Utf8;
import org.codehaus.jackson.JsonNode;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.runtime.beam.avro.AvroSchemas;
import org.talend.sdk.component.runtime.beam.spi.record.AvroPropertyMapper;
import org.talend.sdk.component.runtime.beam.spi.record.AvroSchema;
import org.talend.sdk.component.runtime.beam.spi.record.AvroSchemaBuilder;
import org.talend.sdk.component.runtime.beam.spi.record.SchemaIdGenerator;
import org.talend.sdk.component.runtime.manager.service.api.Unwrappable;
import org.talend.sdk.component.runtime.record.RecordConverters;

public class AvroRecord
implements Record,
AvroPropertyMapper,
Unwrappable {
    private static final RecordConverters RECORD_CONVERTERS = new RecordConverters();
    private static final Schema NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);
    @JsonbTransient
    private final IndexedRecord delegate;
    @JsonbTransient
    private final AvroSchema schema;

    public AvroRecord(IndexedRecord record) {
        this.schema = new AvroSchema(record.getSchema());
        this.delegate = record;
    }

    public AvroRecord(Record record) {
        List entries = record.getSchema().getEntries();
        List<Schema.Field> fields = entries.stream().map(entry -> new Schema.Field(entry.getName(), this.toSchema((Schema.Entry)entry), entry.getComment(), (JsonNode)entry.getDefaultValue())).collect(Collectors.toList());
        Schema avroSchema = Schema.createRecord((String)SchemaIdGenerator.generateRecordName(fields), null, null, (boolean)false);
        avroSchema.setFields(fields);
        this.schema = new AvroSchema(avroSchema);
        this.delegate = new GenericData.Record(avroSchema);
        entries.forEach(entry -> Optional.ofNullable(record.get(Object.class, AvroSchemas.sanitizeConnectionName(entry.getName()))).ifPresent(v -> {
            List avroValue = this.directMapping(v);
            if (Collection.class.isInstance(avroValue)) {
                avroValue = ((Collection)Collection.class.cast(avroValue)).stream().map(this::directMapping).collect(Collectors.toList());
            }
            if (avroValue != null) {
                Schema.Field field = avroSchema.getField(AvroSchemas.sanitizeConnectionName(entry.getName()));
                this.delegate.put(field.pos(), avroValue);
            }
        }));
    }

    private Object directMapping(Object value) {
        if (Record.class.isInstance(value)) {
            return ((Unwrappable)Unwrappable.class.cast(value)).unwrap(IndexedRecord.class);
        }
        if (ZonedDateTime.class.isInstance(value)) {
            return ((ZonedDateTime)ZonedDateTime.class.cast(value)).toInstant().toEpochMilli();
        }
        if (Date.class.isInstance(value)) {
            return ((Date)Date.class.cast(value)).getTime();
        }
        if (byte[].class.isInstance(value)) {
            return ByteBuffer.wrap((byte[])byte[].class.cast(value));
        }
        return value;
    }

    public org.talend.sdk.component.api.record.Schema getSchema() {
        return this.schema;
    }

    public <T> T get(Class<T> expectedType, String name) {
        if (expectedType == Collection.class) {
            return expectedType.cast(this.getArray(Object.class, name));
        }
        return this.doGet(expectedType, name);
    }

    public <T> Collection<T> getArray(Class<T> type, String name) {
        Collection collection = this.doGet(Collection.class, name);
        if (collection == null) {
            return null;
        }
        Schema elementType = AvroSchemas.unwrapUnion(this.delegate.getSchema().getField(name).schema()).getElementType();
        return this.doMapCollection(type, collection, elementType);
    }

    public <T> T unwrap(Class<T> type) {
        if (IndexedRecord.class.isAssignableFrom(type)) {
            return type.cast(this.delegate);
        }
        if (type.isInstance(this)) {
            return type.cast(this);
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroRecord that = (AvroRecord)AvroRecord.class.cast(o);
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    private <T> Collection<T> doMapCollection(Class<T> type, Collection<?> collection, Schema elementType) {
        return Optional.ofNullable(collection).map(c -> c.stream().map(item -> this.doMap(type, elementType, item)).collect(Collectors.toList())).orElse(null);
    }

    private <T> T doGet(Class<T> expectedType, String name) {
        Schema.Field field = this.delegate.getSchema().getField(AvroSchemas.sanitizeConnectionName(name));
        if (field == null) {
            return null;
        }
        Object value = this.delegate.get(field.pos());
        Schema schema = field.schema();
        return this.doMap(expectedType, AvroSchemas.unwrapUnion(schema), value);
    }

    private <T> T doMap(Class<T> expectedType, Schema fieldSchema, Object value) {
        if (Boolean.parseBoolean(this.readProp(fieldSchema, Schema.Type.DATETIME.name())) && Long.class.isInstance(value) && expectedType != Long.class) {
            return (T)RECORD_CONVERTERS.coerce(expectedType, value, fieldSchema.getName());
        }
        if (IndexedRecord.class.isInstance(value) && (Record.class == expectedType || Object.class == expectedType)) {
            return expectedType.cast(new AvroRecord((IndexedRecord)IndexedRecord.class.cast(value)));
        }
        if (GenericArray.class.isInstance(value) && !GenericArray.class.isAssignableFrom(expectedType)) {
            Class itemType = expectedType == Collection.class ? Object.class : expectedType;
            return expectedType.cast(this.doMapCollection(itemType, (Collection)Collection.class.cast(value), fieldSchema.getElementType()));
        }
        if (ByteBuffer.class.isInstance(value) && byte[].class == expectedType) {
            return expectedType.cast(((ByteBuffer)ByteBuffer.class.cast(value)).array());
        }
        if (!expectedType.isInstance(value)) {
            if (Utf8.class.isInstance(value) && String.class == expectedType) {
                return expectedType.cast(value.toString());
            }
            return (T)RECORD_CONVERTERS.coerce(expectedType, value, fieldSchema.getName());
        }
        if (Utf8.class.isInstance(value) && Object.class == expectedType) {
            return expectedType.cast(value.toString());
        }
        return expectedType.cast(value);
    }

    private Schema toSchema(Schema.Entry entry) {
        Schema schema = this.doToSchema(entry);
        if (entry.isNullable() && schema.getType() != Schema.Type.UNION) {
            return Schema.createUnion(Arrays.asList(NULL_SCHEMA, schema));
        }
        if (!entry.isNullable() && schema.getType() == Schema.Type.UNION) {
            return Schema.createUnion(schema.getTypes().stream().filter(it -> it.getType() != Schema.Type.NULL).collect(Collectors.toList()));
        }
        return schema;
    }

    private Schema doToSchema(Schema.Entry entry) {
        Schema.Builder builder = new AvroSchemaBuilder().withType(entry.getType());
        switch (entry.getType()) {
            case ARRAY: {
                Optional.ofNullable(entry.getElementSchema()).ifPresent(arg_0 -> ((Schema.Builder)builder).withElementSchema(arg_0));
                break;
            }
            case RECORD: {
                Optional.ofNullable(entry.getElementSchema()).ifPresent(s -> s.getEntries().forEach(arg_0 -> ((Schema.Builder)builder).withEntry(arg_0)));
                break;
            }
        }
        return (Schema)((Unwrappable)Unwrappable.class.cast(builder.build())).unwrap(Schema.class);
    }

    public String toString() {
        return "AvroRecord{delegate=" + this.delegate + '}';
    }
}

