/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.spi.record;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.json.bind.annotation.JsonbTransient;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.runtime.beam.avro.AvroSchemas;
import org.talend.sdk.component.runtime.beam.spi.record.AvroPropertyMapper;
import org.talend.sdk.component.runtime.manager.service.api.Unwrappable;
import org.talend.sdk.component.runtime.record.SchemaImpl;

public class AvroSchema
implements org.talend.sdk.component.api.record.Schema,
AvroPropertyMapper,
Unwrappable {
    @JsonbTransient
    private final Schema delegate;
    private volatile AvroSchema elementSchema;
    private volatile List<Schema.Entry> entries;
    private volatile Schema.Type type;
    private volatile Schema actualDelegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema getActualDelegate() {
        if (this.actualDelegate != null) {
            return this.actualDelegate;
        }
        AvroSchema avroSchema = this;
        synchronized (avroSchema) {
            if (this.actualDelegate != null) {
                return this.actualDelegate;
            }
            this.actualDelegate = AvroSchemas.unwrapUnion(this.delegate);
        }
        return this.actualDelegate;
    }

    public Schema.Type getType() {
        return this.mapType(this.getActualDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.talend.sdk.component.api.record.Schema getElementSchema() {
        if (this.elementSchema != null) {
            return this.elementSchema;
        }
        if (this.getActualDelegate().getType() == Schema.Type.ARRAY) {
            AvroSchema avroSchema = this;
            synchronized (avroSchema) {
                if (this.elementSchema != null) {
                    return this.elementSchema;
                }
                this.elementSchema = new AvroSchema(this.getActualDelegate().getElementType());
            }
        }
        return this.elementSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Schema.Entry> getEntries() {
        if (this.getActualDelegate().getType() != Schema.Type.RECORD) {
            return Collections.emptyList();
        }
        if (this.entries != null) {
            return this.entries;
        }
        AvroSchema avroSchema = this;
        synchronized (avroSchema) {
            if (this.entries != null) {
                return this.entries;
            }
            this.entries = this.getActualDelegate().getFields().stream().filter(it -> it.schema().getType() != Schema.Type.NULL).map(field -> {
                Schema.Type type = this.mapType(field.schema());
                AvroSchema elementSchema = new AvroSchema(type == Schema.Type.ARRAY ? AvroSchemas.unwrapUnion(field.schema()).getElementType() : field.schema());
                return new SchemaImpl.EntryImpl(field.name(), type, field.schema().getType() == Schema.Type.UNION, field.defaultVal(), (org.talend.sdk.component.api.record.Schema)elementSchema, field.doc());
            }).collect(Collectors.toList());
        }
        return this.entries;
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isInstance(this.delegate)) {
            return type.cast(this.delegate);
        }
        if (type.isInstance(this)) {
            return type.cast(this);
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    private Schema.Type mapType(Schema schema) {
        return this.doMapType(AvroSchemas.unwrapUnion(schema));
    }

    private Schema.Type doMapType(Schema schema) {
        switch (schema.getType()) {
            case LONG: {
                if (Boolean.parseBoolean(this.readProp(schema, Schema.Type.DATETIME.name())) || LogicalTypes.timestampMillis().equals(LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema))) {
                    return Schema.Type.DATETIME;
                }
                return Schema.Type.LONG;
            }
        }
        return Schema.Type.valueOf((String)schema.getType().name());
    }

    public AvroSchema(Schema delegate) {
        this.delegate = delegate;
    }

    public Schema getDelegate() {
        return this.delegate;
    }

    public void setElementSchema(AvroSchema elementSchema) {
        this.elementSchema = elementSchema;
    }

    public void setEntries(List<Schema.Entry> entries) {
        this.entries = entries;
    }

    public void setType(Schema.Type type) {
        this.type = type;
    }

    public void setActualDelegate(Schema actualDelegate) {
        this.actualDelegate = actualDelegate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AvroSchema)) {
            return false;
        }
        AvroSchema other = (AvroSchema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Schema this$delegate = this.getDelegate();
        Schema other$delegate = other.getDelegate();
        if (this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate)) {
            return false;
        }
        org.talend.sdk.component.api.record.Schema this$elementSchema = this.getElementSchema();
        org.talend.sdk.component.api.record.Schema other$elementSchema = other.getElementSchema();
        if (this$elementSchema == null ? other$elementSchema != null : !this$elementSchema.equals(other$elementSchema)) {
            return false;
        }
        List<Schema.Entry> this$entries = this.getEntries();
        List<Schema.Entry> other$entries = other.getEntries();
        if (this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries)) {
            return false;
        }
        Schema.Type this$type = this.getType();
        Schema.Type other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Schema this$actualDelegate = this.getActualDelegate();
        Schema other$actualDelegate = other.getActualDelegate();
        return !(this$actualDelegate == null ? other$actualDelegate != null : !this$actualDelegate.equals(other$actualDelegate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AvroSchema;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Schema $delegate = this.getDelegate();
        result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
        org.talend.sdk.component.api.record.Schema $elementSchema = this.getElementSchema();
        result = result * 59 + ($elementSchema == null ? 43 : $elementSchema.hashCode());
        List<Schema.Entry> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        Schema.Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Schema $actualDelegate = this.getActualDelegate();
        result = result * 59 + ($actualDelegate == null ? 43 : $actualDelegate.hashCode());
        return result;
    }

    public String toString() {
        return "AvroSchema(delegate=" + this.getDelegate() + ")";
    }
}

