/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.coder.registry;

import java.util.concurrent.ExecutionException;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.cache.CacheBuilder;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.cache.CacheLoader;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.cache.LoadingCache;
import org.apache.beam.sdk.coders.AvroCoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AvroCoderCache {
    private static final Logger log = LoggerFactory.getLogger(AvroCoderCache.class);
    private static final LoadingCache<Schema, AvroCoder<IndexedRecord>> CACHED_CODERS = CacheBuilder.newBuilder().maximumSize((long)Integer.getInteger("component.runtime.beam.avrocoder.cache.size", 1024).intValue()).build((CacheLoader)new CacheLoader<Schema, AvroCoder<IndexedRecord>>(){

        public AvroCoder<IndexedRecord> load(Schema schema) {
            return AvroCoder.of(IndexedRecord.class, (Schema)schema);
        }
    });

    static AvroCoder<IndexedRecord> getCoder(Schema avro) {
        try {
            return (AvroCoder)CACHED_CODERS.get((Object)avro);
        }
        catch (ExecutionException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return AvroCoder.of(IndexedRecord.class, (Schema)avro);
        }
    }

    private AvroCoderCache() {
    }
}

