/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.customizer;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

enum Indices {
    BEAM_SDKS_JAVA_CORE("TALEND-INF/classloader/indices/beam-sdks-java-core"){

        @Override
        protected boolean isAvailable() {
            return true;
        }
    }
    ,
    SPARK_CORE("TALEND-INF/classloader/indices/spark-core"){
        private volatile Boolean isThere;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean isAvailable() {
            if (this.isThere == null) {
                2 var1_1 = this;
                synchronized (var1_1) {
                    if (this.isThere == null) {
                        this.isThere = this.hasClass("org.apache.beam.runners.spark.SparkRunner");
                    }
                }
            }
            return this.isThere;
        }
    }
    ,
    SPARK_STREAMING("TALEND-INF/classloader/indices/spark-streaming"){

        @Override
        protected boolean isAvailable() {
            return SPARK_CORE.isAvailable();
        }
    }
    ,
    BEAM_RUNNERS_SPARK("TALEND-INF/classloader/indices/beam-runners-spark-3"){

        @Override
        protected boolean isAvailable() {
            return SPARK_CORE.isAvailable();
        }
    }
    ,
    BEAM_RUNNERS_DIRECT_JAVA("TALEND-INF/classloader/indices/beam-runners-direct-java"){

        @Override
        protected boolean isAvailable() {
            return this.hasClass("org.apache.beam.runners.direct.DirectRunner");
        }
    };

    private final String indexResource;
    private volatile Collection<String> classes;

    protected abstract boolean isAvailable();

    protected boolean hasClass(String name) {
        try {
            Optional.ofNullable(Indices.class.getClassLoader()).orElseGet(ClassLoader::getSystemClassLoader).loadClass(name);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError cnfe) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Stream<String> getClasses() {
        if (this.classes != null) {
            return this.classes.stream();
        }
        Indices indices = this;
        synchronized (indices) {
            if (this.classes != null) {
                return this.classes.stream();
            }
            ClassLoader classLoader = Optional.ofNullable(Indices.class.getClassLoader()).orElseGet(ClassLoader::getSystemClassLoader);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Optional.ofNullable(classLoader).map(loader -> Optional.ofNullable(loader.getResourceAsStream(this.indexResource)).orElseGet(() -> loader.getResourceAsStream(this.indexResource + ".overriden"))).orElseGet(() -> new ByteArrayInputStream(new byte[0])), StandardCharsets.UTF_8));){
                this.classes = reader.lines().map(String::trim).filter(it -> !it.startsWith("#") && !it.isEmpty()).collect(Collectors.toList());
                Stream<String> stream = this.classes.stream();
                return stream;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private Indices(String indexResource) {
        this.indexResource = indexResource;
    }
}

