/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.spi;

import java.io.Serializable;
import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.sdk.transforms.PTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.design.extension.flows.FlowsFactory;
import org.talend.sdk.component.runtime.base.Delegated;
import org.talend.sdk.component.runtime.beam.design.BeamFlowFactory;
import org.talend.sdk.component.runtime.beam.factory.service.AutoValueFluentApiFactory;
import org.talend.sdk.component.runtime.beam.factory.service.PluginCoderFactory;
import org.talend.sdk.component.runtime.beam.transformer.BeamIOTransformer;
import org.talend.sdk.component.runtime.input.Mapper;
import org.talend.sdk.component.runtime.manager.ComponentFamilyMeta;
import org.talend.sdk.component.runtime.output.Processor;
import org.talend.sdk.component.runtime.serialization.ContainerFinder;
import org.talend.sdk.component.spi.component.ComponentExtension;

public class BeamComponentExtension
implements ComponentExtension {
    private static final Logger log = LoggerFactory.getLogger(BeamComponentExtension.class);

    public boolean isActive() {
        try {
            return Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElseGet(ClassLoader::getSystemClassLoader).loadClass("org.apache.beam.sdk.transforms.PTransform").getClassLoader() == this.getClass().getClassLoader();
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    public <T> T unwrap(Class<T> type, Object ... args) {
        if ("org.talend.sdk.component.design.extension.flows.FlowsFactory".equals(type.getName()) && args != null && args.length == 1 && ComponentFamilyMeta.BaseMeta.class.isInstance(args[0]) && ComponentFamilyMeta.ProcessorMeta.class.isInstance(args[0])) {
            try {
                FlowsFactory factory = FlowsFactory.get((ComponentFamilyMeta.BaseMeta)((ComponentFamilyMeta.BaseMeta)ComponentFamilyMeta.BaseMeta.class.cast(args[0])));
                factory.getOutputFlows();
                return type.cast(factory);
            }
            catch (Exception e) {
                return type.cast((Object)BeamFlowFactory.OUTPUT);
            }
        }
        if (type.isInstance(this)) {
            return type.cast(this);
        }
        return null;
    }

    public Collection<ClassFileTransformer> getTransformers() {
        if (Boolean.getBoolean("talend.component.beam.transformers.skip")) {
            return Collections.emptySet();
        }
        String classes = System.getProperty("talend.component.beam.transformers.io.enhanced");
        return Collections.singleton(classes == null ? new BeamIOTransformer() : new BeamIOTransformer(Stream.of(classes.split(",")).map(String::trim).filter(it -> !it.isEmpty()).collect(Collectors.toSet())));
    }

    public void onComponent(ComponentExtension.ComponentContext context) {
        if (PTransform.class.isAssignableFrom(context.getType())) {
            context.skipValidation();
        }
    }

    public boolean supports(Class<?> componentType) {
        return componentType == Mapper.class || componentType == Processor.class;
    }

    public Map<Class<?>, Object> getExtensionServices(final String plugin) {
        return new HashMap<Class<?>, Object>(){
            {
                this.put(AutoValueFluentApiFactory.class, new AutoValueFluentApiFactory());
                this.put(PluginCoderFactory.class, new PluginCoderFactory(plugin));
            }
        };
    }

    public <T> T convert(ComponentExtension.ComponentInstance instance, Class<T> component) {
        if (!this.supports(component)) {
            throw new IllegalArgumentException("Unsupported component API: " + component);
        }
        log.warn("Creating a '{}' instance for '{}#{}', this must be unwrapped before being used", new Object[]{component, instance.family(), instance.name()});
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{component, Serializable.class, Delegated.class}, (InvocationHandler)new LazyComponentHandler(instance.plugin(), instance.family(), instance.name(), (Serializable)Serializable.class.cast(instance.instance())));
    }

    public Collection<String> getAdditionalDependencies() {
        return Collections.singletonList("org.talend.sdk.component:component-runtime-beam:jar:1.34.1");
    }

    private static class LazyComponentHandler
    implements InvocationHandler,
    Serializable {
        private final String plugin;
        private final String family;
        private final String name;
        private final Serializable instance;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ClassLoader loader = ContainerFinder.Instance.get().find(this.plugin).classloader();
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(loader);
            try {
                if (Object.class == method.getDeclaringClass()) {
                    Object object = method.invoke((Object)this.instance, args);
                    return object;
                }
                if (Delegated.class == method.getDeclaringClass()) {
                    Serializable serializable = this.instance;
                    return serializable;
                }
                if ("plugin".equals(method.getName()) && method.getParameterCount() == 0) {
                    String string = this.plugin;
                    return string;
                }
                if ("name".equals(method.getName()) && method.getParameterCount() == 0) {
                    String string = this.name;
                    return string;
                }
                if ("rootName".equals(method.getName()) && method.getParameterCount() == 0) {
                    String string = this.family;
                    return string;
                }
                try {
                    throw new IllegalStateException("Native beam components don't support Talend Component Kit API");
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
        }

        public LazyComponentHandler(String plugin, String family, String name, Serializable instance) {
            this.plugin = plugin;
            this.family = family;
            this.name = name;
            this.instance = instance;
        }
    }
}

