/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.spi.record;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.bind.annotation.JsonbTransient;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.runtime.beam.avro.AvroSchemas;
import org.talend.sdk.component.runtime.beam.spi.record.AvroPropertyMapper;
import org.talend.sdk.component.runtime.manager.service.api.Unwrappable;
import org.talend.sdk.component.runtime.record.SchemaImpl;

public class AvroSchema
implements org.talend.sdk.component.api.record.Schema,
AvroPropertyMapper,
Unwrappable {
    @JsonbTransient
    private final Schema delegate;
    private volatile AvroSchema elementSchema;
    private volatile List<Schema.Entry> entries;
    @JsonbTransient
    private volatile List<Schema.Entry> metadataEntries;
    private volatile Schema.Type type;
    private volatile Schema actualDelegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema getActualDelegate() {
        if (this.actualDelegate != null) {
            return this.actualDelegate;
        }
        AvroSchema avroSchema = this;
        synchronized (avroSchema) {
            if (this.actualDelegate != null) {
                return this.actualDelegate;
            }
            this.actualDelegate = AvroSchemas.unwrapUnion(this.delegate);
        }
        return this.actualDelegate;
    }

    public Schema.Type getType() {
        return this.mapType(this.getActualDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.talend.sdk.component.api.record.Schema getElementSchema() {
        if (this.elementSchema != null) {
            return this.elementSchema;
        }
        if (this.getActualDelegate().getType() == Schema.Type.ARRAY) {
            AvroSchema avroSchema = this;
            synchronized (avroSchema) {
                if (this.elementSchema != null) {
                    return this.elementSchema;
                }
                this.elementSchema = new AvroSchema(this.getActualDelegate().getElementType());
            }
        }
        return this.elementSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Schema.Entry> getEntries() {
        if (this.getActualDelegate().getType() != Schema.Type.RECORD) {
            return Collections.emptyList();
        }
        if (this.entries != null) {
            return this.entries;
        }
        AvroSchema avroSchema = this;
        synchronized (avroSchema) {
            if (this.entries != null) {
                return this.entries;
            }
            this.entries = this.getNonNullFields().filter(f -> !AvroSchema.isMetadata(f)).map(this::fromAvro).collect(Collectors.toList());
        }
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Schema.Entry> getMetadata() {
        if (this.getActualDelegate().getType() != Schema.Type.RECORD) {
            return Collections.emptyList();
        }
        if (this.metadataEntries == null) {
            AvroSchema avroSchema = this;
            synchronized (avroSchema) {
                if (this.metadataEntries == null) {
                    this.metadataEntries = this.getNonNullFields().filter(AvroSchema::isMetadata).map(this::fromAvro).collect(Collectors.toList());
                }
            }
        }
        return this.metadataEntries;
    }

    @JsonbTransient
    public Stream<Schema.Entry> getAllEntries() {
        return Stream.concat(this.getEntries().stream(), this.getMetadata().stream());
    }

    private Stream<Schema.Field> getNonNullFields() {
        return this.getActualDelegate().getFields().stream().filter(it -> it.schema().getType() != Schema.Type.NULL);
    }

    private static boolean isMetadata(Schema.Field f) {
        return f.aliases() != null && f.aliases().contains("talend.field.__METADATA__");
    }

    private Schema.Entry fromAvro(Schema.Field field) {
        Schema.Type type = this.mapType(field.schema());
        AvroSchema elementSchema = new AvroSchema(type == Schema.Type.ARRAY ? AvroSchemas.unwrapUnion(field.schema()).getElementType() : field.schema());
        return AvroSchema.buildFromAvro(field, type, elementSchema);
    }

    private static Schema.Entry buildFromAvro(Schema.Field field, Schema.Type type, AvroSchema elementSchema) {
        return new SchemaImpl.EntryImpl.BuilderImpl().withName(field.name()).withRawName(field.getProp("talend.component.label")).withType(type).withNullable(field.schema().getType() == Schema.Type.UNION).withMetadata(AvroSchema.isMetadata(field)).withDefaultValue(field.defaultVal()).withElementSchema((org.talend.sdk.component.api.record.Schema)elementSchema).withComment(field.doc()).withProps(field.getProps()).build();
    }

    public Map<String, String> getProps() {
        if (this.getActualDelegate().getType() != Schema.Type.RECORD) {
            return Collections.emptyMap();
        }
        return this.getActualDelegate().getProps();
    }

    public String getProp(String property) {
        if (this.getActualDelegate().getType() != Schema.Type.RECORD) {
            return null;
        }
        return this.getActualDelegate().getProp(property);
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isInstance(this.delegate)) {
            return type.cast(this.delegate);
        }
        if (type.isInstance(this)) {
            return type.cast(this);
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    private Schema.Type mapType(Schema schema) {
        return this.doMapType(AvroSchemas.unwrapUnion(schema));
    }

    private Schema.Type doMapType(Schema schema) {
        switch (schema.getType()) {
            case LONG: {
                if (Boolean.parseBoolean(this.readProp(schema, Schema.Type.DATETIME.name())) || LogicalTypes.timestampMillis().equals(LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema))) {
                    return Schema.Type.DATETIME;
                }
                return Schema.Type.LONG;
            }
        }
        return Schema.Type.valueOf((String)schema.getType().name());
    }

    public AvroSchema(Schema delegate) {
        this.delegate = delegate;
    }

    public Schema getDelegate() {
        return this.delegate;
    }

    public List<Schema.Entry> getMetadataEntries() {
        return this.metadataEntries;
    }

    public void setElementSchema(AvroSchema elementSchema) {
        this.elementSchema = elementSchema;
    }

    public void setEntries(List<Schema.Entry> entries) {
        this.entries = entries;
    }

    public void setMetadataEntries(List<Schema.Entry> metadataEntries) {
        this.metadataEntries = metadataEntries;
    }

    public void setType(Schema.Type type) {
        this.type = type;
    }

    public void setActualDelegate(Schema actualDelegate) {
        this.actualDelegate = actualDelegate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AvroSchema)) {
            return false;
        }
        AvroSchema other = (AvroSchema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Schema this$delegate = this.getDelegate();
        Schema other$delegate = other.getDelegate();
        return !(this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AvroSchema;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Schema $delegate = this.getDelegate();
        result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
        return result;
    }

    public String toString() {
        return "AvroSchema(delegate=" + this.getDelegate() + ")";
    }
}

