/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.coder.record;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.SeekableByteArrayInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.commons.compress.utils.IOUtils;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.runtime.beam.avro.AvroSchemas;
import org.talend.sdk.component.runtime.beam.io.NoCloseOutputStream;
import org.talend.sdk.component.runtime.beam.spi.record.AvroRecord;
import org.talend.sdk.component.runtime.manager.service.api.Unwrappable;
import org.talend.sdk.component.runtime.record.Schemas;

public class FullSerializationRecordCoder
extends CustomCoder<Record> {
    private static final GenericData.Record EMPTY_RECORD = new GenericData.Record(AvroSchemas.getEmptySchema());

    public void encode(Record value, OutputStream outputStream) throws IOException {
        Schemas schema = value == null ? Schemas.EMPTY_RECORD : value.getSchema();
        Schema avro = value == null ? AvroSchemas.getEmptySchema() : (Schema)((Unwrappable)Unwrappable.class.cast(schema)).unwrap(Schema.class);
        GenericData.Record record = value == null ? EMPTY_RECORD : (IndexedRecord)((Unwrappable)Unwrappable.class.cast(value)).unwrap(IndexedRecord.class);
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(avro));){
            writer.create(avro, (OutputStream)new NoCloseOutputStream(outputStream));
            writer.append((Object)record);
        }
    }

    public Record decode(InputStream inputStream) throws IOException {
        GenericDatumReader datumReader = new GenericDatumReader();
        try (DataFileReader reader = new DataFileReader((SeekableInput)new SeekableByteArrayInput(IOUtils.toByteArray((InputStream)inputStream)), (DatumReader)datumReader);){
            AvroRecord avroRecord = new AvroRecord((IndexedRecord)reader.next());
            return avroRecord;
        }
    }

    public int hashCode() {
        return FullSerializationRecordCoder.class.hashCode();
    }

    public boolean equals(Object obj) {
        return FullSerializationRecordCoder.class.isInstance(obj);
    }

    public static FullSerializationRecordCoder of() {
        return new FullSerializationRecordCoder();
    }
}

