/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.spi;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.runtime.beam.spi.record.AvroRecordBuilder;
import org.talend.sdk.component.runtime.beam.spi.record.AvroSchemaBuilder;
import org.talend.sdk.component.runtime.manager.service.DefaultServices;
import org.talend.sdk.component.runtime.manager.service.record.RecordBuilderFactoryProvider;
import org.talend.sdk.component.runtime.record.RecordBuilderFactoryImpl;
import org.talend.sdk.component.runtime.record.SchemaImpl;
import org.talend.sdk.component.runtime.serialization.SerializableService;

public class AvroRecordBuilderFactoryProvider
implements RecordBuilderFactoryProvider {
    private static final Logger log = LoggerFactory.getLogger(AvroRecordBuilderFactoryProvider.class);

    public RecordBuilderFactory apply(String containerId) {
        switch (System.getProperty("talend.component.beam.record.factory.impl", "auto")) {
            case "memory": 
            case "default": {
                return new RecordBuilderFactoryImpl(containerId);
            }
            case "avro": {
                return new AvroRecordBuilderFactory(containerId);
            }
        }
        try {
            Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElseGet(ClassLoader::getSystemClassLoader).loadClass("org.codehaus.jackson.node.TextNode");
            return new AvroRecordBuilderFactory(containerId);
        }
        catch (ClassNotFoundException | NoClassDefFoundError cnfe) {
            log.info("jackson-mapper-asl is not available, skipping AvroRecordBuilderFactory ({})", (Object)this.getClass().getName());
            return new RecordBuilderFactoryImpl(containerId);
        }
    }

    private static class AvroRecordBuilderFactory
    extends RecordBuilderFactoryImpl
    implements RecordBuilderFactory,
    Serializable {
        private AvroRecordBuilderFactory(String plugin) {
            super(plugin);
        }

        public Schema.Builder newSchemaBuilder(Schema.Type type) {
            return new AvroSchemaBuilder().withType(type);
        }

        public Record.Builder newRecordBuilder(Schema schema) {
            return new AvroRecordBuilder(schema);
        }

        public Record.Builder newRecordBuilder() {
            return new AvroRecordBuilder();
        }

        public Schema.Entry.Builder newEntryBuilder() {
            return new SchemaImpl.EntryImpl.BuilderImpl();
        }

        Object writeReplace() throws ObjectStreamException {
            if (this.plugin == null) {
                return DefaultServices.lookup((String)RecordBuilderFactory.class.getName());
            }
            return new SerializableService(this.plugin, RecordBuilderFactory.class.getName());
        }
    }
}

