/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.transform;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.runtime.beam.coder.registry.SchemaRegistryCoder;
import org.talend.sdk.component.runtime.serialization.ContainerFinder;

public class ViewsMappingTransform
extends PTransform<PCollection<Record>, PCollection<Record>> {
    private Map<String, PCollectionView<?>> views;
    private String plugin;

    public PCollection<Record> expand(PCollection<Record> input) {
        return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new MappingViewsFn(this.views, this.plugin)));
    }

    protected Coder<?> getDefaultOutputCoder() {
        return SchemaRegistryCoder.of();
    }

    public ViewsMappingTransform(Map<String, PCollectionView<?>> views, String plugin) {
        this.views = views;
        this.plugin = plugin;
    }

    protected ViewsMappingTransform() {
    }

    public static class MappingViewsFn
    extends DoFn<Record, Record> {
        private volatile RecordBuilderFactory builderFactory;
        private String plugin;
        private Map<String, PCollectionView<?>> views;

        private MappingViewsFn(String plugin) {
            this(Collections.emptyMap(), plugin);
        }

        private MappingViewsFn(Map<String, PCollectionView<?>> views, String plugin) {
            this.views = views.entrySet().stream().collect(Collectors.toMap(e -> Schema.sanitizeConnectionName((String)((String)e.getKey())), Map.Entry::getValue));
            this.plugin = plugin;
        }

        @DoFn.ProcessElement
        public void onElement(DoFn.ProcessContext context) {
            context.output((Object)this.createMap(context));
        }

        private Record createMap(DoFn.ProcessContext context) {
            RecordBuilderFactory factory = this.builderFactory();
            Record.Builder builder = factory.newRecordBuilder();
            Record element = (Record)context.element();
            builder.withArray(factory.newEntryBuilder().withName("__default__").withType(Schema.Type.ARRAY).withElementSchema(element.getSchema()).build(), Collections.singletonList(element));
            this.views.forEach((n, v) -> {
                Record sideInput = (Record)Record.class.cast(context.sideInput(v));
                builder.withArray(factory.newEntryBuilder().withName(n).withType(Schema.Type.ARRAY).withElementSchema(element.getSchema()).build(), Collections.singletonList(sideInput));
            });
            return builder.build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RecordBuilderFactory builderFactory() {
            if (this.builderFactory == null) {
                MappingViewsFn mappingViewsFn = this;
                synchronized (mappingViewsFn) {
                    if (this.builderFactory == null) {
                        this.builderFactory = (RecordBuilderFactory)ContainerFinder.Instance.get().find(this.plugin).findService(RecordBuilderFactory.class);
                    }
                }
            }
            return this.builderFactory;
        }

        protected MappingViewsFn() {
        }
    }
}

