/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.transform.avro;

import java.io.Reader;
import java.io.StringReader;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import org.apache.avro.generic.IndexedRecord;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.talend.sdk.component.runtime.beam.coder.JsonpJsonObjectCoder;
import org.talend.sdk.component.runtime.manager.ComponentManager;

public class IndexedRecordToJson
extends PTransform<PCollection<IndexedRecord>, PCollection<JsonObject>> {
    private final JsonReaderFactory factory = ComponentManager.instance().getJsonpReaderFactory();

    public PCollection<JsonObject> expand(PCollection<IndexedRecord> input) {
        return (PCollection)input.apply("IndexedRecordToJson", (PTransform)ParDo.of((DoFn)new Fn(this.factory)));
    }

    protected Coder<?> getDefaultOutputCoder() {
        return JsonpJsonObjectCoder.of(null);
    }

    public static class Fn
    extends DoFn<IndexedRecord, JsonObject> {
        private final JsonReaderFactory factory;

        public Fn(JsonReaderFactory factory) {
            this.factory = factory;
        }

        @DoFn.ProcessElement
        public void onRecord(DoFn.ProcessContext context) {
            context.output((Object)this.toJson((IndexedRecord)context.element()));
        }

        private JsonObject toJson(IndexedRecord element) {
            try (JsonReader reader = this.factory.createReader((Reader)new StringReader(element.toString()));){
                JsonObject jsonObject = reader.readObject();
                return jsonObject;
            }
        }
    }
}

