/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.spi.record;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.runtime.beam.avro.AvroSchemas;
import org.talend.sdk.component.runtime.beam.spi.record.AvroPropertyMapper;
import org.talend.sdk.component.runtime.beam.spi.record.AvroSchema;
import org.talend.sdk.component.runtime.beam.spi.record.SchemaIdGenerator;
import org.talend.sdk.component.runtime.manager.service.api.Unwrappable;
import org.talend.sdk.component.runtime.record.Schemas;

public class AvroSchemaBuilder
implements Schema.Builder {
    private static final Schema NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);
    private static final AvroSchema BYTES_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
    private static final AvroSchema INT_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.INT));
    private static final AvroSchema LONG_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.LONG));
    private static final AvroSchema DATETIME_SCHEMA = new AvroSchema(new AvroPropertyMapper(){}.setProp(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)), Schema.Type.DATETIME.name(), "true"));
    private static final AvroSchema STRING_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.STRING));
    private static final AvroSchema DOUBLE_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.DOUBLE));
    private static final AvroSchema FLOAT_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.FLOAT));
    private static final AvroSchema BOOLEAN_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.BOOLEAN));
    private static final AvroSchema BYTES_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(NULL_SCHEMA, Schema.create((Schema.Type)Schema.Type.BYTES))));
    private static final AvroSchema INT_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(NULL_SCHEMA, Schema.create((Schema.Type)Schema.Type.INT))));
    private static final AvroSchema LONG_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(NULL_SCHEMA, Schema.create((Schema.Type)Schema.Type.LONG))));
    private static final AvroSchema DATETIME_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(NULL_SCHEMA, new AvroPropertyMapper(){}.setProp(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)), Schema.Type.DATETIME.name(), "true"))));
    private static final AvroSchema STRING_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(NULL_SCHEMA, Schema.create((Schema.Type)Schema.Type.STRING))));
    private static final AvroSchema DOUBLE_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(NULL_SCHEMA, Schema.create((Schema.Type)Schema.Type.DOUBLE))));
    private static final AvroSchema FLOAT_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(NULL_SCHEMA, Schema.create((Schema.Type)Schema.Type.FLOAT))));
    private static final AvroSchema BOOLEAN_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(NULL_SCHEMA, Schema.create((Schema.Type)Schema.Type.BOOLEAN))));
    private List<Schema.Entry> fields;
    private Schema.Type type;
    private org.talend.sdk.component.api.record.Schema elementSchema;
    private final Map<String, String> props = new LinkedHashMap<String, String>(0);

    public Schema.Builder withType(Schema.Type type) {
        this.type = type;
        return this;
    }

    public Schema.Builder withEntry(Schema.Entry entry) {
        if (this.type != Schema.Type.RECORD) {
            throw new IllegalArgumentException("entry is only valid for RECORD type of schema");
        }
        if (this.fields == null) {
            this.fields = new ArrayList<Schema.Entry>();
        }
        Schema.Entry realEntry = org.talend.sdk.component.api.record.Schema.avoidCollision((Schema.Entry)entry, this.fields::stream, this::replaceEntry);
        this.fields.add(realEntry);
        return this;
    }

    private void replaceEntry(String entryName, Schema.Entry entry) {
        for (int index = 0; index < this.fields.size(); ++index) {
            if (!Objects.equals(entryName, this.fields.get(index).getName())) continue;
            this.fields.set(index, entry);
            return;
        }
    }

    private Schema.Field entryToAvroField(final Schema.Entry entry) {
        AvroSchema unwrappable;
        switch (entry.getType()) {
            case RECORD: {
                unwrappable = (Unwrappable)Unwrappable.class.cast(entry.getElementSchema());
                break;
            }
            case ARRAY: {
                unwrappable = new Unwrappable(){

                    public <T> T unwrap(Class<T> type) {
                        return type.cast(Schema.createArray((Schema)((Schema)((Unwrappable)Unwrappable.class.cast(entry.getElementSchema())).unwrap(Schema.class))));
                    }
                };
                break;
            }
            case BOOLEAN: {
                unwrappable = !entry.isNullable() ? BOOLEAN_SCHEMA : BOOLEAN_SCHEMA_NULLABLE;
                break;
            }
            case DOUBLE: {
                unwrappable = !entry.isNullable() ? DOUBLE_SCHEMA : DOUBLE_SCHEMA_NULLABLE;
                break;
            }
            case INT: {
                unwrappable = !entry.isNullable() ? INT_SCHEMA : INT_SCHEMA_NULLABLE;
                break;
            }
            case FLOAT: {
                unwrappable = !entry.isNullable() ? FLOAT_SCHEMA : FLOAT_SCHEMA_NULLABLE;
                break;
            }
            case BYTES: {
                unwrappable = !entry.isNullable() ? BYTES_SCHEMA : BYTES_SCHEMA_NULLABLE;
                break;
            }
            case LONG: {
                unwrappable = !entry.isNullable() ? LONG_SCHEMA : LONG_SCHEMA_NULLABLE;
                break;
            }
            case STRING: {
                unwrappable = !entry.isNullable() ? STRING_SCHEMA : STRING_SCHEMA_NULLABLE;
                break;
            }
            case DATETIME: {
                unwrappable = !entry.isNullable() ? DATETIME_SCHEMA : DATETIME_SCHEMA_NULLABLE;
                break;
            }
            default: {
                unwrappable = (Unwrappable)Unwrappable.class.cast(new AvroSchemaBuilder().withType(entry.getType()).build());
            }
        }
        Schema schema = (Schema)((Unwrappable)Unwrappable.class.cast(unwrappable)).unwrap(Schema.class);
        return AvroHelper.toField(schema, entry);
    }

    public Schema.Builder withEntryAfter(String after, Schema.Entry entry) {
        this.withEntry(entry);
        return this.moveAfter(after, entry.getName());
    }

    public Schema.Builder withEntryBefore(String before, Schema.Entry entry) {
        this.withEntry(entry);
        return this.moveBefore(before, entry.getName());
    }

    public Schema.Builder remove(String name) {
        return this.remove(this.fields.get(this.getEntryIndex(name)));
    }

    public Schema.Builder remove(Schema.Entry entry) {
        this.fields.remove(entry);
        return this;
    }

    public Schema.Builder moveAfter(String after, String name) {
        if (this.getEntryIndex(after) == -1) {
            throw new IllegalArgumentException(String.format("%s not in schema", after));
        }
        Schema.Entry entry = this.fields.remove(this.getEntryIndex(name));
        int destination = this.getEntryIndex(after) + 1;
        if (destination < this.fields.size()) {
            this.fields.add(destination, entry);
        } else {
            this.fields.add(entry);
        }
        return this;
    }

    public Schema.Builder moveBefore(String before, String name) {
        if (this.getEntryIndex(before) == -1) {
            throw new IllegalArgumentException(String.format("%s not in schema", before));
        }
        Schema.Entry entry = this.fields.remove(this.getEntryIndex(name));
        this.fields.add(this.getEntryIndex(before), entry);
        return this;
    }

    public Schema.Builder swap(String name, String with) {
        Collections.swap(this.fields, this.getEntryIndex(name), this.getEntryIndex(with));
        return this;
    }

    public Schema.Builder withElementSchema(org.talend.sdk.component.api.record.Schema schema) {
        if (this.type != Schema.Type.ARRAY && schema != null) {
            throw new IllegalArgumentException("elementSchema is only valid for ARRAY type of schema");
        }
        org.talend.sdk.component.api.record.Schema avroSchema = this.toAvroSchema(schema);
        AvroSchema avro = (AvroSchema)avroSchema;
        this.elementSchema = this.wrapNullable(avro);
        return this;
    }

    private AvroSchema wrapNullable(AvroSchema schema) {
        if (schema == null) {
            return null;
        }
        Schema delegate = schema.getDelegate();
        if (delegate.getType() != Schema.Type.UNION) {
            Schema nullableType = Schema.createUnion((Schema[])new Schema[]{delegate, Schema.create((Schema.Type)Schema.Type.NULL)});
            return new AvroSchema(nullableType);
        }
        return schema;
    }

    private int getEntryIndex(String name) {
        for (int index = 0; index < this.fields.size(); ++index) {
            if (!Objects.equals(name, this.fields.get(index).getName())) continue;
            return index;
        }
        return -1;
    }

    private org.talend.sdk.component.api.record.Schema toAvroSchema(org.talend.sdk.component.api.record.Schema schema) {
        if (schema == null || schema instanceof AvroSchema) {
            return schema;
        }
        Schema.Builder builder = new AvroSchemaBuilder().withType(schema.getType());
        org.talend.sdk.component.api.record.Schema elementSchema = schema.getElementSchema();
        if (elementSchema != null) {
            org.talend.sdk.component.api.record.Schema avroSchema = this.toAvroSchema(elementSchema);
            builder.withElementSchema(avroSchema);
        }
        builder.withProps(schema.getProps());
        schema.getEntries().stream().map(this::convertEntry).forEach(arg_0 -> ((Schema.Builder)builder).withEntry(arg_0));
        return builder.build();
    }

    private Schema.Entry convertEntry(Schema.Entry entry) {
        org.talend.sdk.component.api.record.Schema elementSchema = entry.getElementSchema();
        if (elementSchema == null || elementSchema instanceof AvroSchema) {
            return entry;
        }
        org.talend.sdk.component.api.record.Schema avroSchema = this.toAvroSchema(elementSchema);
        return entry.toBuilder().withElementSchema(avroSchema).build();
    }

    public Schema.Builder withProp(String key, String value) {
        this.props.put(key, value);
        return this;
    }

    public Schema.Builder withProps(Map<String, String> props) {
        if (props == null) {
            return this;
        }
        this.props.putAll(props);
        return this;
    }

    public org.talend.sdk.component.api.record.Schema build() {
        return this.build(null);
    }

    public org.talend.sdk.component.api.record.Schema build(Comparator<Schema.Entry> order) {
        switch (this.type) {
            case BYTES: {
                return BYTES_SCHEMA;
            }
            case INT: {
                return INT_SCHEMA;
            }
            case LONG: {
                return LONG_SCHEMA;
            }
            case STRING: {
                return STRING_SCHEMA;
            }
            case DOUBLE: {
                return DOUBLE_SCHEMA;
            }
            case FLOAT: {
                return FLOAT_SCHEMA;
            }
            case BOOLEAN: {
                return BOOLEAN_SCHEMA;
            }
            case DATETIME: {
                return DATETIME_SCHEMA;
            }
            case RECORD: {
                if (this.fields == null) {
                    return new AvroSchema(AvroSchemas.getEmptySchema());
                }
                List<Schema.Field> avroFields = this.fields.stream().map(this::entryToAvroField).collect(Collectors.toList());
                Schema record = Schema.createRecord((String)SchemaIdGenerator.generateRecordName(avroFields), null, (String)"talend.component.schema", (boolean)false);
                record.setFields(avroFields);
                if (order != null) {
                    String entriesOrder = this.fields.stream().sorted(order).map(Schema.Entry::getName).collect(Collectors.joining(","));
                    record.addProp("talend.fields.order", entriesOrder);
                } else {
                    record.addProp("talend.fields.order", this.fields.stream().map(e -> e.getName()).collect(Collectors.joining(",")));
                }
                this.props.entrySet().stream().filter(e -> !"talend.fields.order".equals(e.getKey())).forEach(e -> record.addProp((String)e.getKey(), (String)e.getValue()));
                return new AvroSchema(record);
            }
            case ARRAY: {
                if (this.elementSchema == null) {
                    throw new IllegalStateException("No elementSchema set for this ARRAY schema");
                }
                Schema elementType = this.elementSchema == Schemas.EMPTY_RECORD ? AvroSchemas.getEmptySchema() : (Schema)((Unwrappable)Unwrappable.class.cast(this.elementSchema)).unwrap(Schema.class);
                return new AvroSchema(Schema.createArray((Schema)elementType));
            }
        }
        throw new IllegalArgumentException("Unsupported: " + this.type);
    }

    public static class AvroHelper {
        public static Schema.Field toField(Schema schema, Schema.Entry entry) {
            Schema.Field field = new Schema.Field(org.talend.sdk.component.api.record.Schema.sanitizeConnectionName((String)entry.getName()), entry.isNullable() && schema.getType() != Schema.Type.UNION ? Schema.createUnion(Arrays.asList(NULL_SCHEMA, schema)) : schema, entry.getComment(), entry.getDefaultValue());
            if (entry.isMetadata()) {
                field.addAlias("talend.field.__METADATA__");
            }
            if (entry.getRawName() != null) {
                field.addProp("talend.component.label", entry.getRawName());
            }
            entry.getProps().forEach((k, v) -> field.addProp(k, v));
            return field;
        }
    }
}

