/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.spi.record;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.json.bind.annotation.JsonbTransient;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.util.Utf8;
import org.joda.time.DateTime;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.runtime.beam.avro.AvroSchemas;
import org.talend.sdk.component.runtime.beam.spi.record.AvroPropertyMapper;
import org.talend.sdk.component.runtime.beam.spi.record.AvroRecordBuilder;
import org.talend.sdk.component.runtime.beam.spi.record.AvroSchema;
import org.talend.sdk.component.runtime.manager.service.api.Unwrappable;
import org.talend.sdk.component.runtime.record.RecordConverters;
import org.talend.sdk.component.runtime.record.RecordImpl;

public class AvroRecord
implements Record,
AvroPropertyMapper,
Unwrappable {
    private static final RecordConverters RECORD_CONVERTERS = new RecordConverters();
    @JsonbTransient
    private final IndexedRecord delegate;
    @JsonbTransient
    private final AvroSchema schema;

    public AvroRecord(IndexedRecord record) {
        this.schema = new AvroSchema(record.getSchema());
        this.delegate = record;
        this.delegate.getSchema().getFields().stream().filter(f -> DateTime.class.isInstance(this.delegate.get(f.pos()))).forEach(f -> this.delegate.put(f.pos(), (Object)((DateTime)DateTime.class.cast(this.delegate.get(f.pos()))).getMillis()));
    }

    public AvroRecord(Record record) {
        if (record instanceof AvroRecord) {
            AvroRecord avr = (AvroRecord)record;
            this.delegate = avr.delegate;
            this.schema = avr.schema;
            return;
        }
        this.schema = AvroSchema.toAvroSchema(record.getSchema());
        this.delegate = new GenericData.Record(this.schema.getActualDelegate());
        record.getSchema().getAllEntries().forEach(entry -> Optional.ofNullable(record.get(Object.class, org.talend.sdk.component.api.record.Schema.sanitizeConnectionName((String)entry.getName()))).ifPresent(v -> {
            Object avroValue = this.directMapping(v);
            if (avroValue != null) {
                Schema.Field field = this.schema.getActualDelegate().getField(org.talend.sdk.component.api.record.Schema.sanitizeConnectionName((String)entry.getName()));
                this.delegate.put(field.pos(), avroValue);
            }
        }));
    }

    private Object directMapping(Object value) {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)BigDecimal.class.cast(value)).toString();
        }
        if (value instanceof Collection) {
            return ((Collection)Collection.class.cast(value)).stream().map(this::directMapping).collect(Collectors.toList());
        }
        if (value instanceof RecordImpl) {
            return new AvroRecord((Record)((Record)value)).delegate;
        }
        if (value instanceof Record) {
            return ((Unwrappable)Unwrappable.class.cast(value)).unwrap(IndexedRecord.class);
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)ZonedDateTime.class.cast(value)).toInstant().toEpochMilli();
        }
        if (value instanceof Date) {
            return ((Date)Date.class.cast(value)).getTime();
        }
        if (value instanceof Instant) {
            return new long[]{((Instant)Instant.class.cast(value)).getEpochSecond(), ((Instant)Instant.class.cast(value)).getNano()};
        }
        if (value instanceof byte[]) {
            return ByteBuffer.wrap((byte[])byte[].class.cast(value));
        }
        return value;
    }

    public org.talend.sdk.component.api.record.Schema getSchema() {
        return this.schema;
    }

    public Record.Builder withNewSchema(org.talend.sdk.component.api.record.Schema newSchema) {
        AvroRecordBuilder builder = new AvroRecordBuilder(newSchema);
        newSchema.getAllEntries().filter(e -> Objects.equals(this.schema.getEntry(e.getName()), e)).forEach(e -> builder.with((Schema.Entry)e, this.get(Object.class, e.getName())));
        return builder;
    }

    public <T> T get(Class<T> expectedType, String name) {
        if (expectedType == Collection.class) {
            return expectedType.cast(this.getArray(Object.class, name));
        }
        return this.doGet(expectedType, org.talend.sdk.component.api.record.Schema.sanitizeConnectionName((String)name));
    }

    public <T> T get(Class<T> expectedType, Schema.Entry entry) {
        if (expectedType == Collection.class) {
            return expectedType.cast(this.doGetArray(Object.class, entry.getName()));
        }
        return this.doGet(expectedType, entry.getName());
    }

    public <T> Collection<T> getArray(Class<T> type, String name) {
        String sanitizedName = org.talend.sdk.component.api.record.Schema.sanitizeConnectionName((String)name);
        return this.doGetArray(type, sanitizedName);
    }

    private <T> Collection<T> doGetArray(Class<T> type, String sanitizedName) {
        Collection collection = this.doGet(Collection.class, sanitizedName);
        if (collection == null) {
            return null;
        }
        Schema elementType = AvroSchemas.unwrapUnion(this.delegate.getSchema().getField(sanitizedName).schema()).getElementType();
        return this.doMapCollection(type, collection, elementType);
    }

    public <T> T unwrap(Class<T> type) {
        if (IndexedRecord.class.isAssignableFrom(type)) {
            return type.cast(this.delegate);
        }
        if (type.isInstance(this)) {
            return type.cast(this);
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroRecord that = (AvroRecord)AvroRecord.class.cast(o);
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    private <T> Collection<T> doMapCollection(Class<T> type, Collection<?> collection, Schema elementType) {
        return Optional.ofNullable(collection).map(c -> c.stream().map(item -> this.doMap(type, elementType, item)).collect(Collectors.toList())).orElse(null);
    }

    private <T> T doGet(Class<T> expectedType, String name) {
        Schema.Field field = this.delegate.getSchema().getField(name);
        if (field == null) {
            return null;
        }
        Object value = this.delegate.get(field.pos());
        Schema fieldSchema = field.schema();
        return this.doMap(expectedType, AvroSchemas.unwrapUnion(fieldSchema), value);
    }

    private <T> T doMap(Class<T> expectedType, Schema fieldSchemaRaw, Object value) {
        if (value != null && expectedType == value.getClass() && !(value instanceof Collection)) {
            return expectedType.cast(value);
        }
        if (value instanceof IndexedRecord && (Record.class == expectedType || Object.class == expectedType)) {
            return expectedType.cast(new AvroRecord((IndexedRecord)IndexedRecord.class.cast(value)));
        }
        if (value instanceof ByteBuffer && byte[].class == expectedType) {
            return expectedType.cast(((ByteBuffer)ByteBuffer.class.cast(value)).array());
        }
        Schema fieldSchema = AvroSchemas.unwrapUnion(fieldSchemaRaw);
        if (value instanceof Long && expectedType != Long.class && Boolean.parseBoolean(this.readProp(fieldSchema, Schema.Type.DATETIME.name()))) {
            return (T)RECORD_CONVERTERS.coerce(expectedType, value, fieldSchema.getName());
        }
        if (Boolean.parseBoolean(this.readProp(fieldSchema, Schema.Type.DECIMAL.name()))) {
            if (expectedType == BigDecimal.class) {
                return (T)RECORD_CONVERTERS.coerce(expectedType, value instanceof Utf8 ? value.toString() : value, fieldSchema.getName());
            }
            if (expectedType == Object.class) {
                return (T)RECORD_CONVERTERS.coerce(BigDecimal.class, value instanceof Utf8 ? value.toString() : value, fieldSchema.getName());
            }
        }
        if (value instanceof GenericArray && !GenericArray.class.isAssignableFrom(expectedType)) {
            if (ZonedDateTime.class == expectedType) {
                List longs = ((Collection)Collection.class.cast(value)).stream().collect(Collectors.toList());
                Instant instant = Instant.ofEpochSecond((Long)longs.get(0), (Long)longs.get(1));
                return expectedType.cast(ZonedDateTime.ofInstant(instant, ZoneOffset.UTC));
            }
            if (Instant.class == expectedType) {
                List longs = ((Collection)Collection.class.cast(value)).stream().collect(Collectors.toList());
                Instant instant = Instant.ofEpochSecond((Long)longs.get(0), (Long)longs.get(1));
                return expectedType.cast(instant);
            }
            Class itemType = expectedType == Collection.class ? Object.class : expectedType;
            return expectedType.cast(this.doMapCollection(itemType, (Collection)Collection.class.cast(value), fieldSchema.getElementType()));
        }
        if (value instanceof DateTime && ZonedDateTime.class == expectedType) {
            long epochMilli = ((DateTime)DateTime.class.cast(value)).getMillis();
            return expectedType.cast(ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), ZoneOffset.UTC));
        }
        if (!expectedType.isInstance(value)) {
            if (value instanceof Utf8 && String.class == expectedType) {
                return expectedType.cast(value.toString());
            }
            return (T)RECORD_CONVERTERS.coerce(expectedType, value, fieldSchema.getName());
        }
        if (value instanceof Utf8 && Object.class == expectedType) {
            return expectedType.cast(value.toString());
        }
        if (Collection.class.isAssignableFrom(expectedType) && value instanceof Collection) {
            Schema elementType = fieldSchema.getElementType();
            Schema elementSchema = AvroSchemas.unwrapUnion(elementType);
            Class<Object> toType = Object.class;
            if (elementSchema.getType() == Schema.Type.RECORD) {
                toType = Record.class;
            } else if (elementSchema.getType() == Schema.Type.ARRAY) {
                toType = Collection.class;
            }
            Collection<Object> objects = this.doMapCollection(toType, (Collection)Collection.class.cast(value), elementSchema);
            return expectedType.cast(objects);
        }
        return expectedType.cast(value);
    }

    public String toString() {
        return "AvroRecord{delegate=" + this.delegate + '}';
    }
}

