/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam;

import java.util.function.Consumer;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.Instant;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.runtime.beam.BaseProcessorFn;
import org.talend.sdk.component.runtime.beam.coder.registry.SchemaRegistryCoder;
import org.talend.sdk.component.runtime.output.Processor;

public final class TalendFn {
    private TalendFn() {
    }

    public static PTransform<PCollection<Record>, PCollection<Record>> asFn(Processor processor) {
        return new ProcessorTransform(new ProcessorFn(processor));
    }

    private static class ProcessorTransform
    extends PTransform<PCollection<Record>, PCollection<Record>> {
        private final ProcessorFn fn;

        ProcessorTransform(ProcessorFn fn) {
            this.fn = fn;
        }

        public PCollection<Record> expand(PCollection<Record> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)this.fn));
        }

        protected Coder<?> getDefaultOutputCoder() {
            return SchemaRegistryCoder.of();
        }
    }

    private static class ProcessorFn
    extends BaseProcessorFn<Record> {
        ProcessorFn(Processor processor) {
            super(processor);
        }

        @Override
        protected Consumer<Record> toEmitter(DoFn.ProcessContext context) {
            return arg_0 -> ((DoFn.ProcessContext)context).output(arg_0);
        }

        @Override
        protected BaseProcessorFn.BeamOutputFactory getFinishBundleOutputFactory(DoFn.FinishBundleContext context) {
            return new BaseProcessorFn.BeamMultiOutputFactory(record -> context.output(record, Instant.now(), (BoundedWindow)GlobalWindow.INSTANCE), this.recordFactory, this.jsonb);
        }

        public ProcessorFn() {
        }
    }
}

