/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.spi.record;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.runtime.beam.spi.record.AvroSchema;
import org.talend.sdk.component.runtime.beam.spi.record.AvroSchemaBuilder;
import org.talend.sdk.component.runtime.beam.spi.record.SchemaIdGenerator;
import org.talend.sdk.component.runtime.manager.service.api.Unwrappable;
import org.talend.sdk.component.runtime.record.SchemaImpl;

public class AvroSchemaConverter {
    private static final Schema NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);

    public AvroSchema convert(SchemaImpl schema) {
        Schema.EntriesOrder eo = Schema.EntriesOrder.of((String)schema.getProp("talend.fields.order"));
        List<Schema.Field> fields = schema.getAllEntries().sorted(eo).map(entry -> {
            Schema avroSchema = this.toSchema((Schema.Entry)entry);
            Schema.Field f = AvroSchemaBuilder.AvroHelper.toField(avroSchema, entry);
            return f;
        }).collect(Collectors.toList());
        Schema avroSchema = Schema.createRecord((String)SchemaIdGenerator.generateRecordName(fields), null, null, (boolean)false);
        schema.getProps().forEach((arg_0, arg_1) -> ((Schema)avroSchema).addProp(arg_0, arg_1));
        avroSchema.setFields(fields);
        return new AvroSchema(avroSchema);
    }

    private Schema toSchema(Schema.Entry entry) {
        Schema schema = this.doToSchema(entry);
        if (entry.isNullable() && schema.getType() != Schema.Type.UNION) {
            return Schema.createUnion(Arrays.asList(schema, NULL_SCHEMA));
        }
        if (!entry.isNullable() && schema.getType() == Schema.Type.UNION) {
            return Schema.createUnion(schema.getTypes().stream().filter(it -> it.getType() != Schema.Type.NULL).collect(Collectors.toList()));
        }
        return schema;
    }

    private Schema doToSchema(Schema.Entry entry) {
        Schema.Builder builder = new AvroSchemaBuilder().withType(entry.getType());
        switch (entry.getType()) {
            case ARRAY: {
                Optional.ofNullable(entry.getElementSchema()).ifPresent(arg_0 -> ((Schema.Builder)builder).withElementSchema(arg_0));
                break;
            }
            case RECORD: {
                Optional.ofNullable(entry.getElementSchema()).ifPresent(s -> s.getAllEntries().forEach(arg_0 -> ((Schema.Builder)builder).withEntry(arg_0)));
                break;
            }
        }
        return (Schema)((Unwrappable)Unwrappable.class.cast(builder.build())).unwrap(Schema.class);
    }
}

