/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.spi;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.runtime.beam.spi.record.AvroEntryBuilder;
import org.talend.sdk.component.runtime.beam.spi.record.AvroRecordBuilder;
import org.talend.sdk.component.runtime.beam.spi.record.AvroSchemaBuilder;
import org.talend.sdk.component.runtime.manager.service.DefaultServices;
import org.talend.sdk.component.runtime.manager.service.record.RecordBuilderFactoryProvider;
import org.talend.sdk.component.runtime.record.RecordBuilderFactoryImpl;
import org.talend.sdk.component.runtime.serialization.SerializableService;

public class AvroRecordBuilderFactoryProvider
implements RecordBuilderFactoryProvider {
    private static final Logger log = LoggerFactory.getLogger(AvroRecordBuilderFactoryProvider.class);

    public RecordBuilderFactory apply(String containerId) {
        switch (System.getProperty("talend.component.beam.record.factory.impl", "auto")) {
            case "memory": 
            case "default": {
                return new RecordBuilderFactoryImpl(containerId);
            }
            case "avro": {
                if (!this.hasAvroRecordBuilderFactory()) {
                    log.warn("AvroRecordBuilderFactoryProvider if forced by System property but seems not available, this may lead to issues.");
                }
                return new AvroRecordBuilderFactory(containerId);
            }
        }
        if (this.hasAvroRecordBuilderFactory()) {
            return new AvroRecordBuilderFactory(containerId);
        }
        return new RecordBuilderFactoryImpl(containerId);
    }

    protected boolean hasAvroRecordBuilderFactory() {
        try {
            ClassLoader cl = Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElseGet(ClassLoader::getSystemClassLoader);
            Class<?> c1 = cl.loadClass("com.fasterxml.jackson.databind.node.TextNode");
            Class<?> c2 = cl.loadClass("org.talend.sdk.component.runtime.beam.spi.record.AvroSchema");
            return c1.getClassLoader().equals(c2.getClassLoader());
        }
        catch (ClassNotFoundException | NoClassDefFoundError cnfe) {
            log.info("component-runtime-beam is not available, skipping AvroRecordBuilderFactory ({}).", (Object)this.getClass().getName());
            return false;
        }
    }

    private static class AvroRecordBuilderFactory
    extends RecordBuilderFactoryImpl
    implements RecordBuilderFactory,
    Serializable {
        private AvroRecordBuilderFactory(String plugin) {
            super(plugin);
            if (Boolean.getBoolean("talend.component.record.skip.sanitize")) {
                throw new RuntimeException("component-runtime-beam environment needs `talend.component.record.skip.sanitize` property to be false.");
            }
        }

        public Schema.Builder newSchemaBuilder(Schema.Type type) {
            return new AvroSchemaBuilder().withType(type);
        }

        public Record.Builder newRecordBuilder(Schema schema) {
            return new AvroRecordBuilder(schema);
        }

        public Record.Builder newRecordBuilder() {
            return new AvroRecordBuilder();
        }

        public Schema.Entry.Builder newEntryBuilder() {
            return new AvroEntryBuilder();
        }

        Object writeReplace() throws ObjectStreamException {
            if (this.plugin == null) {
                return DefaultServices.lookup((String)RecordBuilderFactory.class.getName());
            }
            return new SerializableService(this.plugin, RecordBuilderFactory.class.getName());
        }
    }
}

